/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/project#id DataLaunchdarklyProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/project#key DataLaunchdarklyProject#key}
    */
    readonly key: string;
}
export interface DataLaunchdarklyProjectClientSideAvailability {
}
export declare function dataLaunchdarklyProjectClientSideAvailabilityToTerraform(struct?: DataLaunchdarklyProjectClientSideAvailability): any;
export declare class DataLaunchdarklyProjectClientSideAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyProjectClientSideAvailability | undefined;
    set internalValue(value: DataLaunchdarklyProjectClientSideAvailability | undefined);
    get usingEnvironmentId(): cdktf.IResolvable;
    get usingMobileKey(): cdktf.IResolvable;
}
export declare class DataLaunchdarklyProjectClientSideAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyProjectClientSideAvailabilityOutputReference;
}
export interface DataLaunchdarklyProjectDefaultClientSideAvailability {
}
export declare function dataLaunchdarklyProjectDefaultClientSideAvailabilityToTerraform(struct?: DataLaunchdarklyProjectDefaultClientSideAvailability): any;
export declare class DataLaunchdarklyProjectDefaultClientSideAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyProjectDefaultClientSideAvailability | undefined;
    set internalValue(value: DataLaunchdarklyProjectDefaultClientSideAvailability | undefined);
    get usingEnvironmentId(): cdktf.IResolvable;
    get usingMobileKey(): cdktf.IResolvable;
}
export declare class DataLaunchdarklyProjectDefaultClientSideAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyProjectDefaultClientSideAvailabilityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/project launchdarkly_project}
*/
export declare class DataLaunchdarklyProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_project";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyProject resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyProject to import
    * @param importFromId The id of the existing DataLaunchdarklyProject that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyProject to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/project launchdarkly_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyProjectConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyProjectConfig);
    private _clientSideAvailability;
    get clientSideAvailability(): DataLaunchdarklyProjectClientSideAvailabilityList;
    private _defaultClientSideAvailability;
    get defaultClientSideAvailability(): DataLaunchdarklyProjectDefaultClientSideAvailabilityList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get name(): string;
    get tags(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
