/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklySegmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The segment's environment key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment#env_key DataLaunchdarklySegment#env_key}
    */
    readonly envKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment#id DataLaunchdarklySegment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The unique key that references the segment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment#key DataLaunchdarklySegment#key}
    */
    readonly key: string;
    /**
    * The segment's project key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment#project_key DataLaunchdarklySegment#project_key}
    */
    readonly projectKey: string;
}
export interface DataLaunchdarklySegmentExcludedContexts {
}
export declare function dataLaunchdarklySegmentExcludedContextsToTerraform(struct?: DataLaunchdarklySegmentExcludedContexts): any;
export declare class DataLaunchdarklySegmentExcludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentExcludedContexts | undefined;
    set internalValue(value: DataLaunchdarklySegmentExcludedContexts | undefined);
    get contextKind(): string;
    get values(): string[];
}
export declare class DataLaunchdarklySegmentExcludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentExcludedContextsOutputReference;
}
export interface DataLaunchdarklySegmentIncludedContexts {
}
export declare function dataLaunchdarklySegmentIncludedContextsToTerraform(struct?: DataLaunchdarklySegmentIncludedContexts): any;
export declare class DataLaunchdarklySegmentIncludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentIncludedContexts | undefined;
    set internalValue(value: DataLaunchdarklySegmentIncludedContexts | undefined);
    get contextKind(): string;
    get values(): string[];
}
export declare class DataLaunchdarklySegmentIncludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentIncludedContextsOutputReference;
}
export interface DataLaunchdarklySegmentRulesClauses {
}
export declare function dataLaunchdarklySegmentRulesClausesToTerraform(struct?: DataLaunchdarklySegmentRulesClauses): any;
export declare class DataLaunchdarklySegmentRulesClausesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentRulesClauses | undefined;
    set internalValue(value: DataLaunchdarklySegmentRulesClauses | undefined);
    get attribute(): string;
    get contextKind(): string;
    get negate(): cdktf.IResolvable;
    get op(): string;
    get valueType(): string;
    get values(): string[];
}
export declare class DataLaunchdarklySegmentRulesClausesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentRulesClausesOutputReference;
}
export interface DataLaunchdarklySegmentRules {
}
export declare function dataLaunchdarklySegmentRulesToTerraform(struct?: DataLaunchdarklySegmentRules): any;
export declare class DataLaunchdarklySegmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentRules | undefined;
    set internalValue(value: DataLaunchdarklySegmentRules | undefined);
    get bucketBy(): string;
    private _clauses;
    get clauses(): DataLaunchdarklySegmentRulesClausesList;
    get rolloutContextKind(): string;
    get weight(): number;
}
export declare class DataLaunchdarklySegmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment launchdarkly_segment}
*/
export declare class DataLaunchdarklySegment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_segment";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklySegment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklySegment to import
    * @param importFromId The id of the existing DataLaunchdarklySegment that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklySegment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/segment launchdarkly_segment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklySegmentConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklySegmentConfig);
    get creationDate(): number;
    get description(): string;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    get excluded(): string[];
    private _excludedContexts;
    get excludedContexts(): DataLaunchdarklySegmentExcludedContextsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get included(): string[];
    private _includedContexts;
    get includedContexts(): DataLaunchdarklySegmentIncludedContextsList;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get name(): string;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _rules;
    get rules(): DataLaunchdarklySegmentRulesList;
    get tags(): string[];
    get unbounded(): cdktf.IResolvable;
    get unboundedContextKind(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
