/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyTeamMembersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members#emails DataLaunchdarklyTeamMembers#emails}
    */
    readonly emails: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members#id DataLaunchdarklyTeamMembers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members#ignore_missing DataLaunchdarklyTeamMembers#ignore_missing}
    */
    readonly ignoreMissing?: boolean | cdktf.IResolvable;
}
export interface DataLaunchdarklyTeamMembersTeamMembers {
}
export declare function dataLaunchdarklyTeamMembersTeamMembersToTerraform(struct?: DataLaunchdarklyTeamMembersTeamMembers): any;
export declare class DataLaunchdarklyTeamMembersTeamMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyTeamMembersTeamMembers | undefined;
    set internalValue(value: DataLaunchdarklyTeamMembersTeamMembers | undefined);
    get customRoles(): string[];
    get email(): string;
    get firstName(): string;
    get id(): string;
    get lastName(): string;
    get role(): string;
}
export declare class DataLaunchdarklyTeamMembersTeamMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyTeamMembersTeamMembersOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members launchdarkly_team_members}
*/
export declare class DataLaunchdarklyTeamMembers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_team_members";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyTeamMembers resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyTeamMembers to import
    * @param importFromId The id of the existing DataLaunchdarklyTeamMembers that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyTeamMembers to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team_members launchdarkly_team_members} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyTeamMembersConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyTeamMembersConfig);
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    get emailsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreMissing?;
    get ignoreMissing(): boolean | cdktf.IResolvable;
    set ignoreMissing(value: boolean | cdktf.IResolvable);
    resetIgnoreMissing(): void;
    get ignoreMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _teamMembers;
    get teamMembers(): DataLaunchdarklyTeamMembersTeamMembersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
