/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyTeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of keys for custom roles the team has
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#custom_role_keys DataLaunchdarklyTeam#custom_role_keys}
    */
    readonly customRoleKeys?: string[];
    /**
    * The team's description
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#description DataLaunchdarklyTeam#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#id DataLaunchdarklyTeam#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The team's unique key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#key DataLaunchdarklyTeam#key}
    */
    readonly key: string;
    /**
    * The team's human-readable name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#name DataLaunchdarklyTeam#name}
    */
    readonly name?: string;
}
export interface DataLaunchdarklyTeamMaintainers {
}
export declare function dataLaunchdarklyTeamMaintainersToTerraform(struct?: DataLaunchdarklyTeamMaintainers): any;
export declare class DataLaunchdarklyTeamMaintainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyTeamMaintainers | undefined;
    set internalValue(value: DataLaunchdarklyTeamMaintainers | undefined);
    get email(): string;
    get firstName(): string;
    get id(): string;
    get lastName(): string;
    get role(): string;
}
export declare class DataLaunchdarklyTeamMaintainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyTeamMaintainersOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team launchdarkly_team}
*/
export declare class DataLaunchdarklyTeam extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_team";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyTeam resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyTeam to import
    * @param importFromId The id of the existing DataLaunchdarklyTeam that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyTeam to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/team launchdarkly_team} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyTeamConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyTeamConfig);
    private _customRoleKeys?;
    get customRoleKeys(): string[];
    set customRoleKeys(value: string[]);
    resetCustomRoleKeys(): void;
    get customRoleKeysInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _maintainers;
    get maintainers(): DataLaunchdarklyTeamMaintainersList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get projectKeys(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
