/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the webhook
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook#id DataLaunchdarklyWebhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * A human-readable name for your webhook
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook#name DataLaunchdarklyWebhook#name}
    */
    readonly name?: string;
    /**
    * If sign is true, and the secret attribute is omitted, LaunchDarkly will automatically generate a secret for you
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook#secret DataLaunchdarklyWebhook#secret}
    */
    readonly secret?: string;
}
export interface DataLaunchdarklyWebhookStatements {
}
export declare function dataLaunchdarklyWebhookStatementsToTerraform(struct?: DataLaunchdarklyWebhookStatements): any;
export declare class DataLaunchdarklyWebhookStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyWebhookStatements | undefined;
    set internalValue(value: DataLaunchdarklyWebhookStatements | undefined);
    get actions(): string[];
    get effect(): string;
    get notActions(): string[];
    get notResources(): string[];
    get resources(): string[];
}
export declare class DataLaunchdarklyWebhookStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyWebhookStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook launchdarkly_webhook}
*/
export declare class DataLaunchdarklyWebhook extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_webhook";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyWebhook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyWebhook to import
    * @param importFromId The id of the existing DataLaunchdarklyWebhook that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyWebhook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/webhook launchdarkly_webhook} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyWebhookConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyWebhookConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get on(): cdktf.IResolvable;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _statements;
    get statements(): DataLaunchdarklyWebhookStatementsList;
    get tags(): string[];
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
