/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DestinationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The destination-specific configuration. To learn more, read [Destination-Specific Configs](#destination-specific-configs)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#config Destination#config}
    */
    readonly config: {
        [key: string]: string;
    };
    /**
    * The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#env_key Destination#env_key}
    */
    readonly envKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#id Destination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The data export destination type. Available choices are `kinesis`, `google-pubsub`, `mparticle`, `azure-event-hubs`, and `segment`. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#kind Destination#kind}
    */
    readonly kind: string;
    /**
    * A human-readable name for your data export destination.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#name Destination#name}
    */
    readonly name: string;
    /**
    * Whether the data export destination is on or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#on Destination#on}
    */
    readonly on?: boolean | cdktf.IResolvable;
    /**
    * The LaunchDarkly project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#project_key Destination#project_key}
    */
    readonly projectKey: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#tags Destination#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination launchdarkly_destination}
*/
export declare class Destination extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_destination";
    /**
    * Generates CDKTF code for importing a Destination resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Destination to import
    * @param importFromId The id of the existing Destination that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Destination to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/destination launchdarkly_destination} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DestinationConfig
    */
    constructor(scope: Construct, id: string, config: DestinationConfig);
    private _config?;
    get config(): {
        [key: string]: string;
    };
    set config(value: {
        [key: string]: string;
    });
    get configInput(): {
        [key: string]: string;
    } | undefined;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _on?;
    get on(): boolean | cdktf.IResolvable;
    set on(value: boolean | cdktf.IResolvable);
    resetOn(): void;
    get onInput(): boolean | cdktf.IResolvable | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
