/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FeatureFlagEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#env_key FeatureFlagEnvironment#env_key}
    */
    readonly envKey: string;
    /**
    * The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#flag_id FeatureFlagEnvironment#flag_id}
    */
    readonly flagId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#id FeatureFlagEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The index of the variation to serve if targeting is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#off_variation FeatureFlagEnvironment#off_variation}
    */
    readonly offVariation: number;
    /**
    * Whether targeting is enabled. Defaults to `false` if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#on FeatureFlagEnvironment#on}
    */
    readonly on?: boolean | cdktf.IResolvable;
    /**
    * Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#track_events FeatureFlagEnvironment#track_events}
    */
    readonly trackEvents?: boolean | cdktf.IResolvable;
    /**
    * context_targets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#context_targets FeatureFlagEnvironment#context_targets}
    */
    readonly contextTargets?: FeatureFlagEnvironmentContextTargets[] | cdktf.IResolvable;
    /**
    * fallthrough block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#fallthrough FeatureFlagEnvironment#fallthrough}
    */
    readonly fallthrough: FeatureFlagEnvironmentFallthrough;
    /**
    * prerequisites block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#prerequisites FeatureFlagEnvironment#prerequisites}
    */
    readonly prerequisites?: FeatureFlagEnvironmentPrerequisites[] | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#rules FeatureFlagEnvironment#rules}
    */
    readonly rules?: FeatureFlagEnvironmentRules[] | cdktf.IResolvable;
    /**
    * targets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#targets FeatureFlagEnvironment#targets}
    */
    readonly targets?: FeatureFlagEnvironmentTargets[] | cdktf.IResolvable;
}
export interface FeatureFlagEnvironmentContextTargets {
    /**
    * The context kind on which the flag should target in this environment. User (`user`) targets should be specified as `targets` attribute blocks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#context_kind FeatureFlagEnvironment#context_kind}
    */
    readonly contextKind: string;
    /**
    * List of `user` strings to target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#values FeatureFlagEnvironment#values}
    */
    readonly values: string[];
    /**
    * The index of the variation to serve if a user target value is matched.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#variation FeatureFlagEnvironment#variation}
    */
    readonly variation: number;
}
export declare function featureFlagEnvironmentContextTargetsToTerraform(struct?: FeatureFlagEnvironmentContextTargets | cdktf.IResolvable): any;
export declare class FeatureFlagEnvironmentContextTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagEnvironmentContextTargets | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagEnvironmentContextTargets | cdktf.IResolvable | undefined);
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    get contextKindInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
    private _variation?;
    get variation(): number;
    set variation(value: number);
    get variationInput(): number | undefined;
}
export declare class FeatureFlagEnvironmentContextTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagEnvironmentContextTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagEnvironmentContextTargetsOutputReference;
}
export interface FeatureFlagEnvironmentFallthrough {
    /**
    * Group percentage rollout by a custom attribute. This argument is only valid if rollout_weights is also specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#bucket_by FeatureFlagEnvironment#bucket_by}
    */
    readonly bucketBy?: string;
    /**
    * The context kind associated with the specified rollout. This argument is only valid if rollout_weights is also specified. If omitted, defaults to `user`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#context_kind FeatureFlagEnvironment#context_kind}
    */
    readonly contextKind?: string;
    /**
    * List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#rollout_weights FeatureFlagEnvironment#rollout_weights}
    */
    readonly rolloutWeights?: number[];
    /**
    * The default integer variation index to serve if no `prerequisites`, `target`, or `rules` apply. You must specify either `variation` or `rollout_weights`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#variation FeatureFlagEnvironment#variation}
    */
    readonly variation?: number;
}
export declare function featureFlagEnvironmentFallthroughToTerraform(struct?: FeatureFlagEnvironmentFallthroughOutputReference | FeatureFlagEnvironmentFallthrough): any;
export declare class FeatureFlagEnvironmentFallthroughOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FeatureFlagEnvironmentFallthrough | undefined;
    set internalValue(value: FeatureFlagEnvironmentFallthrough | undefined);
    private _bucketBy?;
    get bucketBy(): string;
    set bucketBy(value: string);
    resetBucketBy(): void;
    get bucketByInput(): string | undefined;
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    resetContextKind(): void;
    get contextKindInput(): string | undefined;
    private _rolloutWeights?;
    get rolloutWeights(): number[];
    set rolloutWeights(value: number[]);
    resetRolloutWeights(): void;
    get rolloutWeightsInput(): number[] | undefined;
    private _variation?;
    get variation(): number;
    set variation(value: number);
    resetVariation(): void;
    get variationInput(): number | undefined;
}
export interface FeatureFlagEnvironmentPrerequisites {
    /**
    * The prerequisite feature flag's `key`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#flag_key FeatureFlagEnvironment#flag_key}
    */
    readonly flagKey: string;
    /**
    * The index of the prerequisite feature flag's variation to target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#variation FeatureFlagEnvironment#variation}
    */
    readonly variation: number;
}
export declare function featureFlagEnvironmentPrerequisitesToTerraform(struct?: FeatureFlagEnvironmentPrerequisites | cdktf.IResolvable): any;
export declare class FeatureFlagEnvironmentPrerequisitesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagEnvironmentPrerequisites | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagEnvironmentPrerequisites | cdktf.IResolvable | undefined);
    private _flagKey?;
    get flagKey(): string;
    set flagKey(value: string);
    get flagKeyInput(): string | undefined;
    private _variation?;
    get variation(): number;
    set variation(value: number);
    get variationInput(): number | undefined;
}
export declare class FeatureFlagEnvironmentPrerequisitesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagEnvironmentPrerequisites[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagEnvironmentPrerequisitesOutputReference;
}
export interface FeatureFlagEnvironmentRulesClauses {
    /**
    * The user attribute to operate on
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#attribute FeatureFlagEnvironment#attribute}
    */
    readonly attribute: string;
    /**
    * The context kind associated with this rule clause. This argument is only valid if `rollout_weights` is also specified. If omitted, defaults to `user`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#context_kind FeatureFlagEnvironment#context_kind}
    */
    readonly contextKind?: string;
    /**
    * Whether to negate the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#negate FeatureFlagEnvironment#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#op FeatureFlagEnvironment#op}
    */
    readonly op: string;
    /**
    * The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#value_type FeatureFlagEnvironment#value_type}
    */
    readonly valueType?: string;
    /**
    * The list of values associated with the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#values FeatureFlagEnvironment#values}
    */
    readonly values: string[];
}
export declare function featureFlagEnvironmentRulesClausesToTerraform(struct?: FeatureFlagEnvironmentRulesClauses | cdktf.IResolvable): any;
export declare class FeatureFlagEnvironmentRulesClausesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagEnvironmentRulesClauses | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagEnvironmentRulesClauses | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    resetContextKind(): void;
    get contextKindInput(): string | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class FeatureFlagEnvironmentRulesClausesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagEnvironmentRulesClauses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagEnvironmentRulesClausesOutputReference;
}
export interface FeatureFlagEnvironmentRules {
    /**
    * Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#bucket_by FeatureFlagEnvironment#bucket_by}
    */
    readonly bucketBy?: string;
    /**
    * A human-readable description of the targeting rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#description FeatureFlagEnvironment#description}
    */
    readonly description?: string;
    /**
    * List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#rollout_weights FeatureFlagEnvironment#rollout_weights}
    */
    readonly rolloutWeights?: number[];
    /**
    * The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#variation FeatureFlagEnvironment#variation}
    */
    readonly variation?: number;
    /**
    * clauses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#clauses FeatureFlagEnvironment#clauses}
    */
    readonly clauses?: FeatureFlagEnvironmentRulesClauses[] | cdktf.IResolvable;
}
export declare function featureFlagEnvironmentRulesToTerraform(struct?: FeatureFlagEnvironmentRules | cdktf.IResolvable): any;
export declare class FeatureFlagEnvironmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagEnvironmentRules | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagEnvironmentRules | cdktf.IResolvable | undefined);
    private _bucketBy?;
    get bucketBy(): string;
    set bucketBy(value: string);
    resetBucketBy(): void;
    get bucketByInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _rolloutWeights?;
    get rolloutWeights(): number[];
    set rolloutWeights(value: number[]);
    resetRolloutWeights(): void;
    get rolloutWeightsInput(): number[] | undefined;
    private _variation?;
    get variation(): number;
    set variation(value: number);
    resetVariation(): void;
    get variationInput(): number | undefined;
    private _clauses;
    get clauses(): FeatureFlagEnvironmentRulesClausesList;
    putClauses(value: FeatureFlagEnvironmentRulesClauses[] | cdktf.IResolvable): void;
    resetClauses(): void;
    get clausesInput(): cdktf.IResolvable | FeatureFlagEnvironmentRulesClauses[] | undefined;
}
export declare class FeatureFlagEnvironmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagEnvironmentRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagEnvironmentRulesOutputReference;
}
export interface FeatureFlagEnvironmentTargets {
    /**
    * List of `user` strings to target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#values FeatureFlagEnvironment#values}
    */
    readonly values: string[];
    /**
    * The index of the variation to serve if a user target value is matched.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#variation FeatureFlagEnvironment#variation}
    */
    readonly variation: number;
}
export declare function featureFlagEnvironmentTargetsToTerraform(struct?: FeatureFlagEnvironmentTargets | cdktf.IResolvable): any;
export declare class FeatureFlagEnvironmentTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagEnvironmentTargets | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagEnvironmentTargets | cdktf.IResolvable | undefined);
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
    private _variation?;
    get variation(): number;
    set variation(value: number);
    get variationInput(): number | undefined;
}
export declare class FeatureFlagEnvironmentTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagEnvironmentTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagEnvironmentTargetsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment launchdarkly_feature_flag_environment}
*/
export declare class FeatureFlagEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_feature_flag_environment";
    /**
    * Generates CDKTF code for importing a FeatureFlagEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FeatureFlagEnvironment to import
    * @param importFromId The id of the existing FeatureFlagEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FeatureFlagEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/feature_flag_environment launchdarkly_feature_flag_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FeatureFlagEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: FeatureFlagEnvironmentConfig);
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _flagId?;
    get flagId(): string;
    set flagId(value: string);
    get flagIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offVariation?;
    get offVariation(): number;
    set offVariation(value: number);
    get offVariationInput(): number | undefined;
    private _on?;
    get on(): boolean | cdktf.IResolvable;
    set on(value: boolean | cdktf.IResolvable);
    resetOn(): void;
    get onInput(): boolean | cdktf.IResolvable | undefined;
    private _trackEvents?;
    get trackEvents(): boolean | cdktf.IResolvable;
    set trackEvents(value: boolean | cdktf.IResolvable);
    resetTrackEvents(): void;
    get trackEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _contextTargets;
    get contextTargets(): FeatureFlagEnvironmentContextTargetsList;
    putContextTargets(value: FeatureFlagEnvironmentContextTargets[] | cdktf.IResolvable): void;
    resetContextTargets(): void;
    get contextTargetsInput(): cdktf.IResolvable | FeatureFlagEnvironmentContextTargets[] | undefined;
    private _fallthrough;
    get fallthrough(): FeatureFlagEnvironmentFallthroughOutputReference;
    putFallthrough(value: FeatureFlagEnvironmentFallthrough): void;
    get fallthroughInput(): FeatureFlagEnvironmentFallthrough | undefined;
    private _prerequisites;
    get prerequisites(): FeatureFlagEnvironmentPrerequisitesList;
    putPrerequisites(value: FeatureFlagEnvironmentPrerequisites[] | cdktf.IResolvable): void;
    resetPrerequisites(): void;
    get prerequisitesInput(): cdktf.IResolvable | FeatureFlagEnvironmentPrerequisites[] | undefined;
    private _rules;
    get rules(): FeatureFlagEnvironmentRulesList;
    putRules(value: FeatureFlagEnvironmentRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | FeatureFlagEnvironmentRules[] | undefined;
    private _targets;
    get targets(): FeatureFlagEnvironmentTargetsList;
    putTargets(value: FeatureFlagEnvironmentTargets[] | cdktf.IResolvable): void;
    resetTargets(): void;
    get targetsInput(): cdktf.IResolvable | FeatureFlagEnvironmentTargets[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
