/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#id Project#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether feature flags created under the project should be available to client-side SDKs by default
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#include_in_snippet Project#include_in_snippet}
    */
    readonly includeInSnippet?: boolean | cdktf.IResolvable;
    /**
    * The project's unique key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#key Project#key}
    */
    readonly key: string;
    /**
    * A human-readable name for your project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#name Project#name}
    */
    readonly name: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#tags Project#tags}
    */
    readonly tags?: string[];
    /**
    * default_client_side_availability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#default_client_side_availability Project#default_client_side_availability}
    */
    readonly defaultClientSideAvailability?: ProjectDefaultClientSideAvailability[] | cdktf.IResolvable;
    /**
    * environments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#environments Project#environments}
    */
    readonly environments: ProjectEnvironments[] | cdktf.IResolvable;
}
export interface ProjectDefaultClientSideAvailability {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#using_environment_id Project#using_environment_id}
    */
    readonly usingEnvironmentId: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#using_mobile_key Project#using_mobile_key}
    */
    readonly usingMobileKey: boolean | cdktf.IResolvable;
}
export declare function projectDefaultClientSideAvailabilityToTerraform(struct?: ProjectDefaultClientSideAvailability | cdktf.IResolvable): any;
export declare class ProjectDefaultClientSideAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectDefaultClientSideAvailability | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectDefaultClientSideAvailability | cdktf.IResolvable | undefined);
    private _usingEnvironmentId?;
    get usingEnvironmentId(): boolean | cdktf.IResolvable;
    set usingEnvironmentId(value: boolean | cdktf.IResolvable);
    get usingEnvironmentIdInput(): boolean | cdktf.IResolvable | undefined;
    private _usingMobileKey?;
    get usingMobileKey(): boolean | cdktf.IResolvable;
    set usingMobileKey(value: boolean | cdktf.IResolvable);
    get usingMobileKeyInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ProjectDefaultClientSideAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectDefaultClientSideAvailability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectDefaultClientSideAvailabilityOutputReference;
}
export interface ProjectEnvironmentsApprovalSettings {
    /**
    * Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#can_apply_declined_changes Project#can_apply_declined_changes}
    */
    readonly canApplyDeclinedChanges?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#can_review_own_request Project#can_review_own_request}
    */
    readonly canReviewOwnRequest?: boolean | cdktf.IResolvable;
    /**
    * The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#min_num_approvals Project#min_num_approvals}
    */
    readonly minNumApprovals?: number;
    /**
    * Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#required Project#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#required_approval_tags Project#required_approval_tags}
    */
    readonly requiredApprovalTags?: string[];
}
export declare function projectEnvironmentsApprovalSettingsToTerraform(struct?: ProjectEnvironmentsApprovalSettings | cdktf.IResolvable): any;
export declare class ProjectEnvironmentsApprovalSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectEnvironmentsApprovalSettings | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectEnvironmentsApprovalSettings | cdktf.IResolvable | undefined);
    private _canApplyDeclinedChanges?;
    get canApplyDeclinedChanges(): boolean | cdktf.IResolvable;
    set canApplyDeclinedChanges(value: boolean | cdktf.IResolvable);
    resetCanApplyDeclinedChanges(): void;
    get canApplyDeclinedChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _canReviewOwnRequest?;
    get canReviewOwnRequest(): boolean | cdktf.IResolvable;
    set canReviewOwnRequest(value: boolean | cdktf.IResolvable);
    resetCanReviewOwnRequest(): void;
    get canReviewOwnRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _minNumApprovals?;
    get minNumApprovals(): number;
    set minNumApprovals(value: number);
    resetMinNumApprovals(): void;
    get minNumApprovalsInput(): number | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredApprovalTags?;
    get requiredApprovalTags(): string[];
    set requiredApprovalTags(value: string[]);
    resetRequiredApprovalTags(): void;
    get requiredApprovalTagsInput(): string[] | undefined;
}
export declare class ProjectEnvironmentsApprovalSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectEnvironmentsApprovalSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectEnvironmentsApprovalSettingsOutputReference;
}
export interface ProjectEnvironments {
    /**
    * The color swatch as an RGB hex value with no leading `#`. For example: `000000`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#color Project#color}
    */
    readonly color: string;
    /**
    * Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#confirm_changes Project#confirm_changes}
    */
    readonly confirmChanges?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/home/data-export).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#default_track_events Project#default_track_events}
    */
    readonly defaultTrackEvents?: boolean | cdktf.IResolvable;
    /**
    * The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/home/organize/environments#ttl-settings).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#default_ttl Project#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * The project-unique key for the environment. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#key Project#key}
    */
    readonly key: string;
    /**
    * The name of the environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#name Project#name}
    */
    readonly name: string;
    /**
    * Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#require_comments Project#require_comments}
    */
    readonly requireComments?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#secure_mode Project#secure_mode}
    */
    readonly secureMode?: boolean | cdktf.IResolvable;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#tags Project#tags}
    */
    readonly tags?: string[];
    /**
    * approval_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#approval_settings Project#approval_settings}
    */
    readonly approvalSettings?: ProjectEnvironmentsApprovalSettings[] | cdktf.IResolvable;
}
export declare function projectEnvironmentsToTerraform(struct?: ProjectEnvironments | cdktf.IResolvable): any;
export declare class ProjectEnvironmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectEnvironments | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectEnvironments | cdktf.IResolvable | undefined);
    get apiKey(): string;
    get clientSideId(): string;
    private _color?;
    get color(): string;
    set color(value: string);
    get colorInput(): string | undefined;
    private _confirmChanges?;
    get confirmChanges(): boolean | cdktf.IResolvable;
    set confirmChanges(value: boolean | cdktf.IResolvable);
    resetConfirmChanges(): void;
    get confirmChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultTrackEvents?;
    get defaultTrackEvents(): boolean | cdktf.IResolvable;
    set defaultTrackEvents(value: boolean | cdktf.IResolvable);
    resetDefaultTrackEvents(): void;
    get defaultTrackEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get mobileKey(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requireComments?;
    get requireComments(): boolean | cdktf.IResolvable;
    set requireComments(value: boolean | cdktf.IResolvable);
    resetRequireComments(): void;
    get requireCommentsInput(): boolean | cdktf.IResolvable | undefined;
    private _secureMode?;
    get secureMode(): boolean | cdktf.IResolvable;
    set secureMode(value: boolean | cdktf.IResolvable);
    resetSecureMode(): void;
    get secureModeInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _approvalSettings;
    get approvalSettings(): ProjectEnvironmentsApprovalSettingsList;
    putApprovalSettings(value: ProjectEnvironmentsApprovalSettings[] | cdktf.IResolvable): void;
    resetApprovalSettings(): void;
    get approvalSettingsInput(): cdktf.IResolvable | ProjectEnvironmentsApprovalSettings[] | undefined;
}
export declare class ProjectEnvironmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectEnvironments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectEnvironmentsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project launchdarkly_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_project";
    /**
    * Generates CDKTF code for importing a Project resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Project to import
    * @param importFromId The id of the existing Project that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Project to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/project launchdarkly_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeInSnippet?;
    get includeInSnippet(): boolean | cdktf.IResolvable;
    set includeInSnippet(value: boolean | cdktf.IResolvable);
    resetIncludeInSnippet(): void;
    get includeInSnippetInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _defaultClientSideAvailability;
    get defaultClientSideAvailability(): ProjectDefaultClientSideAvailabilityList;
    putDefaultClientSideAvailability(value: ProjectDefaultClientSideAvailability[] | cdktf.IResolvable): void;
    resetDefaultClientSideAvailability(): void;
    get defaultClientSideAvailabilityInput(): cdktf.IResolvable | ProjectDefaultClientSideAvailability[] | undefined;
    private _environments;
    get environments(): ProjectEnvironmentsList;
    putEnvironments(value: ProjectEnvironments[] | cdktf.IResolvable): void;
    get environmentsInput(): cdktf.IResolvable | ProjectEnvironments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
