/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SegmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the segment's purpose.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#description Segment#description}
    */
    readonly description?: string;
    /**
    * The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#env_key Segment#env_key}
    */
    readonly envKey: string;
    /**
    * List of user keys excluded from the segment. To target on other context kinds, use the excluded_contexts block attribute. This attribute is not valid when `unbounded` is set to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#excluded Segment#excluded}
    */
    readonly excluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#id Segment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of user keys included in the segment. To target on other context kinds, use the included_contexts block attribute. This attribute is not valid when `unbounded` is set to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#included Segment#included}
    */
    readonly included?: string[];
    /**
    * The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#key Segment#key}
    */
    readonly key: string;
    /**
    * The human-friendly name for the segment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#name Segment#name}
    */
    readonly name: string;
    /**
    * The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#project_key Segment#project_key}
    */
    readonly projectKey: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#tags Segment#tags}
    */
    readonly tags?: string[];
    /**
    * Whether to create a standard segment (`false`) or a Big Segment (`true`). Standard segments include rule-based and smaller list-based segments. Big Segments include larger list-based segments and synced segments. Only use a Big Segment if you need to add more than 15,000 individual targets. It is not possible to manage the list of targeted contexts for Big Segments with Terraform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#unbounded Segment#unbounded}
    */
    readonly unbounded?: boolean | cdktf.IResolvable;
    /**
    * For Big Segments, the targeted context kind. If this attribute is not specified it will default to `user`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#unbounded_context_kind Segment#unbounded_context_kind}
    */
    readonly unboundedContextKind?: string;
    /**
    * excluded_contexts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#excluded_contexts Segment#excluded_contexts}
    */
    readonly excludedContexts?: SegmentExcludedContexts[] | cdktf.IResolvable;
    /**
    * included_contexts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#included_contexts Segment#included_contexts}
    */
    readonly includedContexts?: SegmentIncludedContexts[] | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#rules Segment#rules}
    */
    readonly rules?: SegmentRules[] | cdktf.IResolvable;
}
export interface SegmentExcludedContexts {
    /**
    * The context kind associated with this segment target. To target on user contexts, use the included and excluded attributes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#context_kind Segment#context_kind}
    */
    readonly contextKind: string;
    /**
    * List of target object keys included in or excluded from the segment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#values Segment#values}
    */
    readonly values: string[];
}
export declare function segmentExcludedContextsToTerraform(struct?: SegmentExcludedContexts | cdktf.IResolvable): any;
export declare class SegmentExcludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SegmentExcludedContexts | cdktf.IResolvable | undefined;
    set internalValue(value: SegmentExcludedContexts | cdktf.IResolvable | undefined);
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    get contextKindInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class SegmentExcludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SegmentExcludedContexts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SegmentExcludedContextsOutputReference;
}
export interface SegmentIncludedContexts {
    /**
    * The context kind associated with this segment target. To target on user contexts, use the included and excluded attributes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#context_kind Segment#context_kind}
    */
    readonly contextKind: string;
    /**
    * List of target object keys included in or excluded from the segment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#values Segment#values}
    */
    readonly values: string[];
}
export declare function segmentIncludedContextsToTerraform(struct?: SegmentIncludedContexts | cdktf.IResolvable): any;
export declare class SegmentIncludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SegmentIncludedContexts | cdktf.IResolvable | undefined;
    set internalValue(value: SegmentIncludedContexts | cdktf.IResolvable | undefined);
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    get contextKindInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class SegmentIncludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SegmentIncludedContexts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SegmentIncludedContextsOutputReference;
}
export interface SegmentRulesClauses {
    /**
    * The user attribute to operate on
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#attribute Segment#attribute}
    */
    readonly attribute: string;
    /**
    * The context kind associated with this rule clause. This argument is only valid if `rollout_weights` is also specified. If omitted, defaults to `user`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#context_kind Segment#context_kind}
    */
    readonly contextKind?: string;
    /**
    * Whether to negate the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#negate Segment#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#op Segment#op}
    */
    readonly op: string;
    /**
    * The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#value_type Segment#value_type}
    */
    readonly valueType?: string;
    /**
    * The list of values associated with the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#values Segment#values}
    */
    readonly values: string[];
}
export declare function segmentRulesClausesToTerraform(struct?: SegmentRulesClauses | cdktf.IResolvable): any;
export declare class SegmentRulesClausesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SegmentRulesClauses | cdktf.IResolvable | undefined;
    set internalValue(value: SegmentRulesClauses | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    resetContextKind(): void;
    get contextKindInput(): string | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class SegmentRulesClausesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SegmentRulesClauses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SegmentRulesClausesOutputReference;
}
export interface SegmentRules {
    /**
    * The attribute by which to group users together.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#bucket_by Segment#bucket_by}
    */
    readonly bucketBy?: string;
    /**
    * The context kind associated with this segment rule. This argument is only valid if weight is also specified. If omitted, defaults to 'user'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#rollout_context_kind Segment#rollout_context_kind}
    */
    readonly rolloutContextKind?: string;
    /**
    * The integer weight of the rule (between 1 and 100000).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#weight Segment#weight}
    */
    readonly weight?: number;
    /**
    * clauses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#clauses Segment#clauses}
    */
    readonly clauses?: SegmentRulesClauses[] | cdktf.IResolvable;
}
export declare function segmentRulesToTerraform(struct?: SegmentRules | cdktf.IResolvable): any;
export declare class SegmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SegmentRules | cdktf.IResolvable | undefined;
    set internalValue(value: SegmentRules | cdktf.IResolvable | undefined);
    private _bucketBy?;
    get bucketBy(): string;
    set bucketBy(value: string);
    resetBucketBy(): void;
    get bucketByInput(): string | undefined;
    private _rolloutContextKind?;
    get rolloutContextKind(): string;
    set rolloutContextKind(value: string);
    resetRolloutContextKind(): void;
    get rolloutContextKindInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _clauses;
    get clauses(): SegmentRulesClausesList;
    putClauses(value: SegmentRulesClauses[] | cdktf.IResolvable): void;
    resetClauses(): void;
    get clausesInput(): cdktf.IResolvable | SegmentRulesClauses[] | undefined;
}
export declare class SegmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SegmentRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SegmentRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment launchdarkly_segment}
*/
export declare class Segment extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_segment";
    /**
    * Generates CDKTF code for importing a Segment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Segment to import
    * @param importFromId The id of the existing Segment that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Segment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/segment launchdarkly_segment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SegmentConfig
    */
    constructor(scope: Construct, id: string, config: SegmentConfig);
    get creationDate(): number;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _excluded?;
    get excluded(): string[];
    set excluded(value: string[]);
    resetExcluded(): void;
    get excludedInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _included?;
    get included(): string[];
    set included(value: string[]);
    resetIncluded(): void;
    get includedInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _unbounded?;
    get unbounded(): boolean | cdktf.IResolvable;
    set unbounded(value: boolean | cdktf.IResolvable);
    resetUnbounded(): void;
    get unboundedInput(): boolean | cdktf.IResolvable | undefined;
    private _unboundedContextKind?;
    get unboundedContextKind(): string;
    set unboundedContextKind(value: string);
    resetUnboundedContextKind(): void;
    get unboundedContextKindInput(): string | undefined;
    private _excludedContexts;
    get excludedContexts(): SegmentExcludedContextsList;
    putExcludedContexts(value: SegmentExcludedContexts[] | cdktf.IResolvable): void;
    resetExcludedContexts(): void;
    get excludedContextsInput(): cdktf.IResolvable | SegmentExcludedContexts[] | undefined;
    private _includedContexts;
    get includedContexts(): SegmentIncludedContextsList;
    putIncludedContexts(value: SegmentIncludedContexts[] | cdktf.IResolvable): void;
    resetIncludedContexts(): void;
    get includedContextsInput(): cdktf.IResolvable | SegmentIncludedContexts[] | undefined;
    private _rules;
    get rules(): SegmentRulesList;
    putRules(value: SegmentRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | SegmentRules[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
