/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * IDs or keys of custom roles. Team members must have either a role or custom role
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#custom_roles TeamMember#custom_roles}
    */
    readonly customRoles?: string[];
    /**
    * The team member's email address
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#email TeamMember#email}
    */
    readonly email: string;
    /**
    * The team member's first name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#first_name TeamMember#first_name}
    */
    readonly firstName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#id TeamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The team member's last name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#last_name TeamMember#last_name}
    */
    readonly lastName?: string;
    /**
    * The team member's role. This must be reader, writer, admin, or no_access. Team members must have either a role or custom role
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#role TeamMember#role}
    */
    readonly role?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member launchdarkly_team_member}
*/
export declare class TeamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_team_member";
    /**
    * Generates CDKTF code for importing a TeamMember resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TeamMember to import
    * @param importFromId The id of the existing TeamMember that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TeamMember to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_member launchdarkly_team_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamMemberConfig
    */
    constructor(scope: Construct, id: string, config: TeamMemberConfig);
    private _customRoles?;
    get customRoles(): string[];
    set customRoles(value: string[]);
    resetCustomRoles(): void;
    get customRolesInput(): string[] | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    resetFirstName(): void;
    get firstNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    resetLastName(): void;
    get lastNameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
