/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamRoleMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of custom role keys to assign to the team.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_role_mapping#custom_role_keys TeamRoleMapping#custom_role_keys}
    */
    readonly customRoleKeys: string[];
    /**
    * The LaunchDarkly team key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_role_mapping#team_key TeamRoleMapping#team_key}
    */
    readonly teamKey: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_role_mapping launchdarkly_team_role_mapping}
*/
export declare class TeamRoleMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_team_role_mapping";
    /**
    * Generates CDKTF code for importing a TeamRoleMapping resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TeamRoleMapping to import
    * @param importFromId The id of the existing TeamRoleMapping that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_role_mapping#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TeamRoleMapping to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/team_role_mapping launchdarkly_team_role_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamRoleMappingConfig
    */
    constructor(scope: Construct, id: string, config: TeamRoleMappingConfig);
    private _customRoleKeys?;
    get customRoleKeys(): string[];
    set customRoleKeys(value: string[]);
    get customRoleKeysInput(): string[] | undefined;
    get id(): string;
    private _teamKey?;
    get teamKey(): string;
    set teamKey(value: string);
    get teamKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
