/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#id Webhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A human-readable name for your webhook
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#name Webhook#name}
    */
    readonly name?: string;
    /**
    * Whether this webhook is enabled or not
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#on Webhook#on}
    */
    readonly on?: boolean | cdktf.IResolvable;
    /**
    * If sign is true, and the secret attribute is omitted, LaunchDarkly will automatically generate a secret for you
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#secret Webhook#secret}
    */
    readonly secret?: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#tags Webhook#tags}
    */
    readonly tags?: string[];
    /**
    * The URL of the remote webhook
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#url Webhook#url}
    */
    readonly url: string;
    /**
    * statements block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#statements Webhook#statements}
    */
    readonly statements?: WebhookStatements[] | cdktf.IResolvable;
}
export interface WebhookStatements {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
    * Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#actions Webhook#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#effect Webhook#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#not_actions Webhook#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#not_resources Webhook#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#resources Webhook#resources}
    */
    readonly resources?: string[];
}
export declare function webhookStatementsToTerraform(struct?: WebhookStatements | cdktf.IResolvable): any;
export declare class WebhookStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebhookStatements | cdktf.IResolvable | undefined;
    set internalValue(value: WebhookStatements | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class WebhookStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebhookStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebhookStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook launchdarkly_webhook}
*/
export declare class Webhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_webhook";
    /**
    * Generates CDKTF code for importing a Webhook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Webhook to import
    * @param importFromId The id of the existing Webhook that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Webhook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/webhook launchdarkly_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebhookConfig
    */
    constructor(scope: Construct, id: string, config: WebhookConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _on?;
    get on(): boolean | cdktf.IResolvable;
    set on(value: boolean | cdktf.IResolvable);
    resetOn(): void;
    get onInput(): boolean | cdktf.IResolvable | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _statements;
    get statements(): WebhookStatementsList;
    putStatements(value: WebhookStatements[] | cdktf.IResolvable): void;
    resetStatements(): void;
    get statementsInput(): cdktf.IResolvable | WebhookStatements[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
