import { JsiiProjectOptions, JsiiProject } from 'projen';
/**
 * Configurable knobs for Awesome Lists.
 *
 * @stability stable
 */
export interface AwesomeListProjectOptions extends JsiiProjectOptions {
    /**
     * What e-mail address to list for the Code of Conduct Point of Contact.
     *
     * @default - `project.authorAddress`
     * @stability stable
     */
    readonly contactEmail?: string;
}
/**
 * Awesome List project.
 *
 * @stability stable
 * @pjid awesome-list
 */
export declare class AwesomeList extends JsiiProject {
    /**
     * @stability stable
     */
    constructor(options: AwesomeListProjectOptions);
    private _awesomeLint;
    private codeOfConduct;
    private contributing;
}
