#!/usr/bin/env python3

"""MODULE: Provides functions for preparing, then printing, retrieved data."""

from tabulate import tabulate


def generate_prefix_string(prefixes: list) -> str | None:
    """Generate a string that spilts prefixes into rows of 4."""
    num_per_row = 4
    try:
        ret: str = ""
        for i in range(0, len(prefixes), num_per_row):
            ret += ", ".join(prefixes[i : i + num_per_row]) + "\n"
        return ret
    except AttributeError:
        return None


def print_table(table_data) -> None:  # pragma: no cover
    """Print table generated by tabulate."""
    print(tabulate(table_data))
