import sys
from enum import Enum

from loguru import logger


class LogLevel(str, Enum):
    debug = "debug"
    info = "info"
    warning = "warning"
    error = "error"
    critical = "critical"

    # Enum of Python3.10 returns a different string representation.
    # Make it return the same as in Python3.11
    def __str__(self):
        return str(self.value)


def setup_logger(log_level: LogLevel):
    logger.remove()
    logger.add(sys.stderr, level=log_level.value.upper())
