"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DaemonSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const workload = require("./workload");
/**
 * A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.
 * As nodes are added to the cluster, Pods are added to them.
 * As nodes are removed from the cluster, those Pods are garbage collected.
 * Deleting a DaemonSet will clean up the Pods it created.
 *
 * Some typical uses of a DaemonSet are:
 *
 * - running a cluster storage daemon on every node
 * - running a logs collection daemon on every node
 * - running a node monitoring daemon on every node
 *
 * In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
 * A more complex setup might use multiple DaemonSets for a single type of daemon,
 * but with different flags and/or different memory and cpu requests for different hardware types.
 */
class DaemonSet extends workload.Workload {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.resourceType = 'daemonsets';
        this.apiObject = new k8s.KubeDaemonSet(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.minReadySeconds = props.minReadySeconds ?? 0;
        if (this.isolate) {
            this.connections.isolate();
        }
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            minReadySeconds: this.minReadySeconds,
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            selector: this._toLabelSelector(),
        };
    }
}
exports.DaemonSet = DaemonSet;
_a = JSII_RTTI_SYMBOL_1;
DaemonSet[_a] = { fqn: "cdk8s-plus-23.DaemonSet", version: "2.0.44" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGFlbW9uLXNldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kYWVtb24tc2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsaUNBQXdDO0FBRXhDLHFDQUFxQztBQUNyQyx1Q0FBdUM7QUFpQnZDOzs7Ozs7Ozs7Ozs7Ozs7R0FlRztBQUNILE1BQWEsU0FBVSxTQUFRLFFBQVEsQ0FBQyxRQUFRO0lBVzlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBd0IsRUFBRTtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUxWLGlCQUFZLEdBQUcsWUFBWSxDQUFDO1FBTzFDLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxHQUFHLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDdkQsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLElBQUksRUFBRSxZQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDO1NBQ2xELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsSUFBSSxDQUFDLENBQUM7UUFFbEQsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hCLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUM7U0FDNUI7SUFDSCxDQUFDO0lBRUQ7O09BRUc7SUFDSSxPQUFPO1FBQ1osT0FBTztZQUNMLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxRQUFRLEVBQUU7Z0JBQ1IsUUFBUSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxFQUFFO2dCQUNuQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRTthQUN4QjtZQUNELFFBQVEsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7U0FDbEMsQ0FBQztJQUNKLENBQUM7O0FBdENILDhCQXdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwaU9iamVjdCwgTGF6eSB9IGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgazhzIGZyb20gJy4vaW1wb3J0cy9rOHMnO1xuaW1wb3J0ICogYXMgd29ya2xvYWQgZnJvbSAnLi93b3JrbG9hZCc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYERhZW1vblNldGAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRGFlbW9uU2V0UHJvcHMgZXh0ZW5kcyB3b3JrbG9hZC5Xb3JrbG9hZFByb3BzIHtcblxuICAvKipcbiAgICogTWluaW11bSBudW1iZXIgb2Ygc2Vjb25kcyBmb3Igd2hpY2ggYSBuZXdseSBjcmVhdGVkIHBvZCBzaG91bGRcbiAgICogYmUgcmVhZHkgd2l0aG91dCBhbnkgb2YgaXRzIGNvbnRhaW5lciBjcmFzaGluZywgZm9yIGl0IHRvIGJlIGNvbnNpZGVyZWQgYXZhaWxhYmxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAwXG4gICAqL1xuICByZWFkb25seSBtaW5SZWFkeVNlY29uZHM/OiBudW1iZXI7XG5cbn1cblxuLyoqXG4gKiBBIERhZW1vblNldCBlbnN1cmVzIHRoYXQgYWxsIChvciBzb21lKSBOb2RlcyBydW4gYSBjb3B5IG9mIGEgUG9kLlxuICogQXMgbm9kZXMgYXJlIGFkZGVkIHRvIHRoZSBjbHVzdGVyLCBQb2RzIGFyZSBhZGRlZCB0byB0aGVtLlxuICogQXMgbm9kZXMgYXJlIHJlbW92ZWQgZnJvbSB0aGUgY2x1c3RlciwgdGhvc2UgUG9kcyBhcmUgZ2FyYmFnZSBjb2xsZWN0ZWQuXG4gKiBEZWxldGluZyBhIERhZW1vblNldCB3aWxsIGNsZWFuIHVwIHRoZSBQb2RzIGl0IGNyZWF0ZWQuXG4gKlxuICogU29tZSB0eXBpY2FsIHVzZXMgb2YgYSBEYWVtb25TZXQgYXJlOlxuICpcbiAqIC0gcnVubmluZyBhIGNsdXN0ZXIgc3RvcmFnZSBkYWVtb24gb24gZXZlcnkgbm9kZVxuICogLSBydW5uaW5nIGEgbG9ncyBjb2xsZWN0aW9uIGRhZW1vbiBvbiBldmVyeSBub2RlXG4gKiAtIHJ1bm5pbmcgYSBub2RlIG1vbml0b3JpbmcgZGFlbW9uIG9uIGV2ZXJ5IG5vZGVcbiAqXG4gKiBJbiBhIHNpbXBsZSBjYXNlLCBvbmUgRGFlbW9uU2V0LCBjb3ZlcmluZyBhbGwgbm9kZXMsIHdvdWxkIGJlIHVzZWQgZm9yIGVhY2ggdHlwZSBvZiBkYWVtb24uXG4gKiBBIG1vcmUgY29tcGxleCBzZXR1cCBtaWdodCB1c2UgbXVsdGlwbGUgRGFlbW9uU2V0cyBmb3IgYSBzaW5nbGUgdHlwZSBvZiBkYWVtb24sXG4gKiBidXQgd2l0aCBkaWZmZXJlbnQgZmxhZ3MgYW5kL29yIGRpZmZlcmVudCBtZW1vcnkgYW5kIGNwdSByZXF1ZXN0cyBmb3IgZGlmZmVyZW50IGhhcmR3YXJlIHR5cGVzLlxuICovXG5leHBvcnQgY2xhc3MgRGFlbW9uU2V0IGV4dGVuZHMgd29ya2xvYWQuV29ya2xvYWQge1xuXG4gIC8qKlxuICAgKiBAc2VlIGJhc2UuUmVzb3VyY2UuYXBpT2JqZWN0XG4gICAqL1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYXBpT2JqZWN0OiBBcGlPYmplY3Q7XG5cbiAgcHVibGljIHJlYWRvbmx5IHJlc291cmNlVHlwZSA9ICdkYWVtb25zZXRzJztcblxuICBwdWJsaWMgcmVhZG9ubHkgbWluUmVhZHlTZWNvbmRzOiBudW1iZXI7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERhZW1vblNldFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIHRoaXMuYXBpT2JqZWN0ID0gbmV3IGs4cy5LdWJlRGFlbW9uU2V0KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG1ldGFkYXRhOiBwcm9wcy5tZXRhZGF0YSxcbiAgICAgIHNwZWM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5fdG9LdWJlKCkgfSksXG4gICAgfSk7XG5cbiAgICB0aGlzLm1pblJlYWR5U2Vjb25kcyA9IHByb3BzLm1pblJlYWR5U2Vjb25kcyA/PyAwO1xuXG4gICAgaWYgKHRoaXMuaXNvbGF0ZSkge1xuICAgICAgdGhpcy5jb25uZWN0aW9ucy5pc29sYXRlKCk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF90b0t1YmUoKTogazhzLkRhZW1vblNldFNwZWMge1xuICAgIHJldHVybiB7XG4gICAgICBtaW5SZWFkeVNlY29uZHM6IHRoaXMubWluUmVhZHlTZWNvbmRzLFxuICAgICAgdGVtcGxhdGU6IHtcbiAgICAgICAgbWV0YWRhdGE6IHRoaXMucG9kTWV0YWRhdGEudG9Kc29uKCksXG4gICAgICAgIHNwZWM6IHRoaXMuX3RvUG9kU3BlYygpLFxuICAgICAgfSxcbiAgICAgIHNlbGVjdG9yOiB0aGlzLl90b0xhYmVsU2VsZWN0b3IoKSxcbiAgICB9O1xuICB9XG5cbn0iXX0=