"""
This type stub file was generated by cyright.
"""

import numpy as np
import cython
from scipy.sparse import csr_matrix

DTYPE = np.float64
@cython.cclass
class Metric:
    @cython.cfunc
    @cython.nogil
    @cython.exceptval(check=False)
    def compute(self, term: cython.Py_ssize_t, tf: cython.double, p_c: cython.double, p_b: cython.double) -> cython.double:
        ...
    


@cython.final
@cython.cclass
class Kld(Metric):
    mu_smoothing: cython.double
    l_smoothing: cython.double
    def __init__(self, mu_smoothing: cython.double = ..., l_smoothing: cython.double = ...) -> None:
        ...
    
    @cython.final
    @cython.ccall
    @cython.nogil
    @cython.inline
    @cython.exceptval(check=False)
    def compute(self, term: cython.Py_ssize_t, tf: cython.double, p_c: cython.double, p_b: cython.double) -> cython.double:
        ...
    


@cython.final
@cython.cclass
class Qkld(Metric):
    query_biased_term_weights: cython.double[: 1]
    mu_smoothing: cython.double
    l_smoothing: cython.double
    b_smoothing: cython.double
    def __init__(self, query_biased_term_weights: cython.double[: 1], mu_smoothing: cython.double = ..., l_smoothing: cython.double = ..., b_smoothing: cython.double = ...) -> None:
        ...
    
    @cython.final
    @cython.ccall
    @cython.nogil
    @cython.inline
    @cython.exceptval(check=False)
    def compute(self, term: cython.Py_ssize_t, tf: cython.double, p_c: cython.double, p_b: cython.double) -> cython.double:
        ...
    


@cython.nogil
@cython.cfunc
@cython.inline
@cython.exceptval(check=False)
def skld(tf: cython.double, p_c: cython.double, p_b: cython.double, l_smoothing: cython.double, mu_smoothing: cython.double) -> cython.double:
    ...

@cython.exceptval(check=False)
def assign_documents_to_clusters(docs: csr_matrix, centroids: cython.double[:, : 1], background_model: cython.double[: 1], metric: Metric) -> tuple[np.ndarray, np.ndarray]:
    ...

@cython.exceptval(check=False)
def fill_empty_clusters(assignments_np: np.ndarray, similarities_np: np.ndarray, nclusters: cython.int) -> tuple[np.ndarray]:
    ...

@cython.exceptval(check=False)
def recompute_centroids(docs: csr_matrix, assignments: cython.int[: 1], nclusters: cython.int) -> np.ndarray:
    ...

@cython.exceptval(check=False)
def normalize_documents(docs: csr_matrix) -> csr_matrix:
    ...

@cython.exceptval(check=False)
def compute_cluster_sizes(assignment: cython.int[: 1], nclusters: cython.int) -> np.ndarray:
    ...

