# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, constr

from .. import EnvScopedObjectReference, GlobalObjectReference
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    fcpm_v2 = 'fcpm/v2'


class Kind(Enum):
    compute_pool = 'ComputePool'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/fcpm/v2/compute-pools/lfcp-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/flink-region=aws.us-east-2/compute-pool=lfcp-12345'
        ],
    )


class ComputePoolStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ..., description='Status of the Flink compute pool.', examples=['PROVISIONING']
    )
    current_cfu: int = Field(
        ...,
        description='The number of Confluent Flink Units (CFUs) currently allocated to this Flink compute pool.',
        examples=[4],
    )


class Kind1Model(Enum):
    region = 'Region'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/fcpm/v2/regions/r-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/region=r-12345'
        ],
    )


class Region(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model] = None
    display_name: Optional[str] = Field(
        None, description='The display name.', examples=['Ohio (us-east-2)']
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider that hosts the region.',
        examples=['AWS'],
    )
    region_name: Optional[str] = Field(
        None, description='The region name.', examples=['us-east-2']
    )
    http_endpoint: Optional[AnyUrl] = Field(
        None, description='The regional API endpoint for Flink compute pools.'
    )
    private_http_endpoint: Optional[AnyUrl] = Field(
        None, description='The private regional API endpoint for Flink compute pools.'
    )


class Kind1Model1(Enum):
    compute_pool_list = 'ComputePoolList'


class Metadata1Model1(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/fcpm/v2/compute-pools']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/compute-pools?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/compute-pools?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/compute-pools?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ComputePoolSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[constr(pattern=r'^(?:[0-9A-Za-z\-])[\w\.-]{0,31}$')] = Field(
        None,
        description='The name of the Flink compute pool.',
        examples=['flink_compute_pool_0'],
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider that runs the compute pool.',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None,
        description='Flink compute pools in the region provided will be able to use this identity pool',
        examples=['us-west-1'],
    )
    max_cfu: Optional[int] = Field(
        None,
        description='Maximum number of Confluent Flink Units (CFUs) that the Flink compute pool should auto-scale to.\n',
        examples=[5],
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[EnvScopedObjectReference] = Field(
        None, description='The network to which this belongs.'
    )


class Kind1Model2(Enum):
    region_list = 'RegionList'


class Metadata1Model2(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/fcpm/v2/regions']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/regions?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/regions?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/fcpm/v2/regions?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class RegionList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model2 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model2
    data: List[Region] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ComputePoolSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[constr(pattern=r'^(?:[0-9A-Za-z\-])[\w\.-]{0,31}$')] = Field(
        None,
        description='The name of the Flink compute pool.',
        examples=['flink_compute_pool_0'],
    )
    max_cfu: Optional[int] = Field(
        None,
        description='Maximum number of Confluent Flink Units (CFUs) that the Flink compute pool should auto-scale to.\n',
        examples=[5],
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model3(Enum):
    compute_pool = 'ComputePool'


class Metadata1Model3(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/fcpm/v2/compute-pools/lfcp-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/flink-region=aws.us-east-2/compute-pool=lfcp-12345'
        ],
    )


class ComputePoolUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model3] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model3] = None
    spec: Optional[ComputePoolSpecUpdate] = None
    status: Optional[ComputePoolStatus] = None


class ComputePool(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    spec: Optional[ComputePoolSpec] = None
    status: Optional[ComputePoolStatus] = None


class Datum(ComputePool):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ComputePoolList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model1 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model1
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
