// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#pragma once

// If you want to use the paddle2onnx static library, add the
// registration logic here synchronously each time you add a new op.
#ifndef WITH_PADDLE2ONNX_STATIC_INTERNAL
/* #undef WITH_PADDLE2ONNX_STATIC_INTERNAL */
#endif

#if defined(WITH_PADDLE2ONNX_STATIC_INTERNAL)
#if (!defined(WITH_PADDLE2ONNX_STATIC_INTERNAL_AT_COMPILING))

#if defined(_WIN32)
#define UNUSED
#define __builtin_expect(EXP, C) (EXP)
#else
#define UNUSED __attribute__((unused))
#endif

#define USE_P2O_MAPPER(op_name, class_name)                           \
  namespace paddle2onnx {                                             \
    extern int Touch##op_name##class_name();                          \
    int op_name##__registry__ UNUSED = Touch##op_name##class_name();  \
  }

USE_P2O_MAPPER(quantize_linear, QuantizeLinearMapper)
USE_P2O_MAPPER(dequantize_linear, DequantizeLinearMapper)
USE_P2O_MAPPER(batch_norm, BatchNormMapper)
USE_P2O_MAPPER(dropout, DropoutMapper)
USE_P2O_MAPPER(layer_norm, LayerNormMapper)
USE_P2O_MAPPER(rnn, RnnMapper)
USE_P2O_MAPPER(softmax_with_cross_entropy, SoftmaxCrossEntropyLossMapper)
USE_P2O_MAPPER(affine_channel, AffineChannelMapper)
USE_P2O_MAPPER(conv3d, Conv3dMapper)
USE_P2O_MAPPER(conv2d_transpose, Conv2dTransposeMapper)
USE_P2O_MAPPER(depthwise_conv2d_transpose, Conv2dTransposeMapper)
USE_P2O_MAPPER(conv2d, Conv2dMapper)
USE_P2O_MAPPER(depthwise_conv2d, Conv2dMapper)
USE_P2O_MAPPER(pool3d, Pool3dMapper)
USE_P2O_MAPPER(max_pool3d_with_index, Pool3dMapper)
USE_P2O_MAPPER(instance_norm, InstanceNormMapper)
USE_P2O_MAPPER(pool2d, Pool2dMapper)
USE_P2O_MAPPER(max_pool2d_with_index, Pool2dMapper)
USE_P2O_MAPPER(shape, ShapeMapper)
USE_P2O_MAPPER(bilinear_interp, InterpolateMapper)
USE_P2O_MAPPER(bilinear_interp_v2, InterpolateMapper)
USE_P2O_MAPPER(nearest_interp_v2, InterpolateMapper)
USE_P2O_MAPPER(bicubic_interp_v2, InterpolateMapper)
USE_P2O_MAPPER(linear_interp_v2, InterpolateMapper)
USE_P2O_MAPPER(trilinear_interp_v2, InterpolateMapper)
USE_P2O_MAPPER(data_norm, DataNormMapper)
USE_P2O_MAPPER(norm, NormMapper)
USE_P2O_MAPPER(group_norm, GroupNormMapper)
USE_P2O_MAPPER(pad3d, Pad3DMapper)
USE_P2O_MAPPER(relu, ActivationMapper)
USE_P2O_MAPPER(relu6, Relu6Mapper)
USE_P2O_MAPPER(tanh, ActivationMapper)
USE_P2O_MAPPER(log, ActivationMapper)
USE_P2O_MAPPER(sigmoid, ActivationMapper)
USE_P2O_MAPPER(sqrt, ActivationMapper)
USE_P2O_MAPPER(softplus, ActivationMapper)
USE_P2O_MAPPER(exp, ActivationMapper)
USE_P2O_MAPPER(floor, ActivationMapper)
USE_P2O_MAPPER(cos, ActivationMapper)
USE_P2O_MAPPER(sin, ActivationMapper)
USE_P2O_MAPPER(round, ActivationMapper)
USE_P2O_MAPPER(abs, ActivationMapper)
USE_P2O_MAPPER(acos, ActivationMapper)
USE_P2O_MAPPER(asin, ActivationMapper)
USE_P2O_MAPPER(atan, ActivationMapper)
USE_P2O_MAPPER(sinh, ActivationMapper)
USE_P2O_MAPPER(tan, ActivationMapper)
USE_P2O_MAPPER(ceil, ActivationMapper)
USE_P2O_MAPPER(cosh, ActivationMapper)
USE_P2O_MAPPER(softsign, ActivationMapper)
USE_P2O_MAPPER(sign, ActivationMapper)
USE_P2O_MAPPER(erf, ActivationMapper)
USE_P2O_MAPPER(reciprocal, ActivationMapper)
USE_P2O_MAPPER(leaky_relu, LeakyReluMapper)
USE_P2O_MAPPER(gelu, GeluMapper)
USE_P2O_MAPPER(selu, SeluMapper)
USE_P2O_MAPPER(prelu, PReluMapper)
USE_P2O_MAPPER(hard_sigmoid, HardSigmoidMapper)
USE_P2O_MAPPER(swish, SwishMapper)
USE_P2O_MAPPER(hard_swish, HardSwishMapper)
USE_P2O_MAPPER(softmax, SoftMaxMapper)
USE_P2O_MAPPER(brelu, BReluMapper)
USE_P2O_MAPPER(elu, EluMapper)
USE_P2O_MAPPER(hard_shrink, HardShrinkMapper)
USE_P2O_MAPPER(softshrink, SoftShrinkMapper)
USE_P2O_MAPPER(mish, MishMapper)
USE_P2O_MAPPER(square, SquareMapper)
USE_P2O_MAPPER(size, SizeMapper)
USE_P2O_MAPPER(rsqrt, RsqrtMapper)
USE_P2O_MAPPER(logsigmoid, LogSigmoidMapper)
USE_P2O_MAPPER(log_softmax, LogSoftmaxMapper)
USE_P2O_MAPPER(tanh_shrink, TanhShrinkMapper)
USE_P2O_MAPPER(thresholded_relu, ThresholdedReluMapper)
USE_P2O_MAPPER(log1p, Log1PMapper)
USE_P2O_MAPPER(log2, Log2Mapper)
USE_P2O_MAPPER(log10, Log10Mapper)
USE_P2O_MAPPER(silu, SiluMapper)
USE_P2O_MAPPER(elementwise_add, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_sub, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_div, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_mul, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_min, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_max, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_pow, ElementwiseMapper)
USE_P2O_MAPPER(elementwise_mod, ElementWiseModMapper)
USE_P2O_MAPPER(elementwise_floordiv, ElementWiseFloordivMapper)
USE_P2O_MAPPER(flatten2, Flatten2Mapper)
USE_P2O_MAPPER(squeeze2, Squeeze2Mapper)
USE_P2O_MAPPER(clip, ClipMapper)
USE_P2O_MAPPER(pixel_shuffle, PixelShuffleMapper)
USE_P2O_MAPPER(one_hot_v2, OneHotV2Mapper)
USE_P2O_MAPPER(expand_v2, ExpandV2Mapper)
USE_P2O_MAPPER(cumsum, CumsumMapper)
USE_P2O_MAPPER(dot, DotMapper)
USE_P2O_MAPPER(less_than, LessThanMapper)
USE_P2O_MAPPER(reshape2, Reshape2Mapper)
USE_P2O_MAPPER(not_equal, NotEqualMapper)
USE_P2O_MAPPER(arg_min, ArgMinMapper)
USE_P2O_MAPPER(matmul_v2, MatmulV2Mapper)
USE_P2O_MAPPER(greater_equal, GreaterEqualMapper)
USE_P2O_MAPPER(scale, ScaleMapper)
USE_P2O_MAPPER(expand, ExpandMapper)
USE_P2O_MAPPER(dist, DistMapper)
USE_P2O_MAPPER(expand_as_v2, ExpandAsMapper)
USE_P2O_MAPPER(p_norm, PNormMapper)
USE_P2O_MAPPER(split, SplitMapper)
USE_P2O_MAPPER(mean, MeanMapper)
USE_P2O_MAPPER(set_value, SetValueMapper)
USE_P2O_MAPPER(transpose2, Transpose2Mapper)
USE_P2O_MAPPER(temporal_shift, TemporalShiftMapper)
USE_P2O_MAPPER(mul, MulMapper)
USE_P2O_MAPPER(flip, FlipMapper)
USE_P2O_MAPPER(bmm, BmmMapper)
USE_P2O_MAPPER(index_select, IndexSelectMapper)
USE_P2O_MAPPER(stack, StackMapper)
USE_P2O_MAPPER(gather_nd, GatherNdMapper)
USE_P2O_MAPPER(lookup_table, LookupTableMapper)
USE_P2O_MAPPER(lookup_table_v2, LookupTableMapper)
USE_P2O_MAPPER(meshgrid, MeshgridMapper)
USE_P2O_MAPPER(scatter, ScatterMapper)
USE_P2O_MAPPER(assign, AssignMapper)
USE_P2O_MAPPER(share_data, AssignMapper)
USE_P2O_MAPPER(scatter_nd_add, ScatterNdAddMapper)
USE_P2O_MAPPER(top_k_v2, TopKV2Mapper)
USE_P2O_MAPPER(range, RangeMapper)
USE_P2O_MAPPER(logical_not, LogicalNotMapper)
USE_P2O_MAPPER(linspace, LinspaceMapper)
USE_P2O_MAPPER(eye, EyeMapper)
USE_P2O_MAPPER(where, WhereMapper)
USE_P2O_MAPPER(unique, UniqueMapper)
USE_P2O_MAPPER(assign_value, AssignValueMapper)
USE_P2O_MAPPER(unstack, UnstackMapper)
USE_P2O_MAPPER(fill_any_like, FillLikeMapper)
USE_P2O_MAPPER(fill_zeros_like, FillLikeMapper)
USE_P2O_MAPPER(partial_sum, PartialOpsMapper)
USE_P2O_MAPPER(partial_concat, PartialOpsMapper)
USE_P2O_MAPPER(top_k, TopKMapper)
USE_P2O_MAPPER(grid_sampler, GridSamplerMapper)
USE_P2O_MAPPER(sum, AddNMapper)
USE_P2O_MAPPER(unsqueeze2, Unsqueeze2Mapper)
USE_P2O_MAPPER(arg_max, ArgMaxMapper)
USE_P2O_MAPPER(cast, CastMapper)
USE_P2O_MAPPER(matmul, MatmulMapper)
USE_P2O_MAPPER(gather, GatherMapper)
USE_P2O_MAPPER(fill_constant, FillConstantMapper)
USE_P2O_MAPPER(take_along_axis, TakeAlongAxisMapper)
USE_P2O_MAPPER(greater_than, GreaterThanMapper)
USE_P2O_MAPPER(argsort, ArgsortMapper)
USE_P2O_MAPPER(pow, PowMapper)
USE_P2O_MAPPER(tile, TileMapper)
USE_P2O_MAPPER(logical_and, LogicalOpMapper)
USE_P2O_MAPPER(logical_or, LogicalOpMapper)
USE_P2O_MAPPER(logical_xor, LogicalOpMapper)
USE_P2O_MAPPER(fill_constant_batch_size_like, FillConstantBatchSizeLikeMapper)
USE_P2O_MAPPER(slice, SliceMapper)
USE_P2O_MAPPER(strided_slice, SliceMapper)
USE_P2O_MAPPER(where_index, NonZeroMapper)
USE_P2O_MAPPER(reduce_mean, ReduceMapper)
USE_P2O_MAPPER(reduce_sum, ReduceMapper)
USE_P2O_MAPPER(reduce_min, ReduceMapper)
USE_P2O_MAPPER(reduce_max, ReduceMapper)
USE_P2O_MAPPER(reduce_prod, ReduceMapper)
USE_P2O_MAPPER(logsumexp, ReduceMapper)
USE_P2O_MAPPER(reduce_all, ReduceMapper)
USE_P2O_MAPPER(reduce_any, ReduceMapper)
USE_P2O_MAPPER(concat, ConcatMapper)
USE_P2O_MAPPER(less_equal, LessEqualMapper)
USE_P2O_MAPPER(gaussian_random, GaussianRandomMapper)
USE_P2O_MAPPER(flatten_contiguous_range, FlattenMapper)
USE_P2O_MAPPER(equal, EqualMapper)
USE_P2O_MAPPER(yolo_box, YoloBoxMapper)
USE_P2O_MAPPER(multiclass_nms3, NMSMapper)
USE_P2O_MAPPER(roi_align, RoiAlignMapper)
USE_P2O_MAPPER(index_sample, IndexSampleMapper)
USE_P2O_MAPPER(mv, MvMapper)
#endif // WITH_PADDLE2ONNX_STATIC_INTERNAL_AT_COMPILING
#endif // WITH_PADDLE2ONNX_STATIC_INTERNAL
