# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LiveToolsCableArgs', 'LiveToolsCable']

@pulumi.input_type
class LiveToolsCableArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 callback: Optional[pulumi.Input['LiveToolsCableCallbackArgs']] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a LiveToolsCable resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input['LiveToolsCableCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of ports for which to perform the cable test.
        """
        pulumi.set(__self__, "serial", serial)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsCableCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsCableCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ports for which to perform the cable test.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class _LiveToolsCableState:
    def __init__(__self__, *,
                 cable_test_id: Optional[pulumi.Input[str]] = None,
                 callback: Optional[pulumi.Input['LiveToolsCableCallbackArgs']] = None,
                 error: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request: Optional[pulumi.Input['LiveToolsCableRequestArgs']] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsCableResultArgs']]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LiveToolsCable resources.
        :param pulumi.Input[str] cable_test_id: Id of the cable test request. Used to check the status of the request.
        :param pulumi.Input['LiveToolsCableCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] error: An error message for a failed execution
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of ports for which to perform the cable test.
        :param pulumi.Input['LiveToolsCableRequestArgs'] request: Cable test request parameters
        :param pulumi.Input[Sequence[pulumi.Input['LiveToolsCableResultArgs']]] results: Results of the cable test request, one for each requested port.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[str] status: Status of the cable test request.
        :param pulumi.Input[str] url: GET this url to check the status of your cable test request.
        """
        if cable_test_id is not None:
            pulumi.set(__self__, "cable_test_id", cable_test_id)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if results is not None:
            pulumi.set(__self__, "results", results)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="cableTestId")
    def cable_test_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the cable test request. Used to check the status of the request.
        """
        return pulumi.get(self, "cable_test_id")

    @cable_test_id.setter
    def cable_test_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cable_test_id", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsCableCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsCableCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ports for which to perform the cable test.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['LiveToolsCableRequestArgs']]:
        """
        Cable test request parameters
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['LiveToolsCableRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsCableResultArgs']]]]:
        """
        Results of the cable test request, one for each requested port.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveToolsCableResultArgs']]]]):
        pulumi.set(self, "results", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the cable test request.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        GET this url to check the status of your cable test request.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class LiveToolsCable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsCableCallbackArgs', 'LiveToolsCableCallbackArgsDict']]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a LiveToolsCable resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LiveToolsCableCallbackArgs', 'LiveToolsCableCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of ports for which to perform the cable test.
        :param pulumi.Input[str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LiveToolsCableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LiveToolsCable resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LiveToolsCableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LiveToolsCableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsCableCallbackArgs', 'LiveToolsCableCallbackArgsDict']]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LiveToolsCableArgs.__new__(LiveToolsCableArgs)

            __props__.__dict__["callback"] = callback
            __props__.__dict__["ports"] = ports
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["cable_test_id"] = None
            __props__.__dict__["error"] = None
            __props__.__dict__["request"] = None
            __props__.__dict__["results"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["url"] = None
        super(LiveToolsCable, __self__).__init__(
            'meraki:devices/liveToolsCable:LiveToolsCable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cable_test_id: Optional[pulumi.Input[str]] = None,
            callback: Optional[pulumi.Input[Union['LiveToolsCableCallbackArgs', 'LiveToolsCableCallbackArgsDict']]] = None,
            error: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            request: Optional[pulumi.Input[Union['LiveToolsCableRequestArgs', 'LiveToolsCableRequestArgsDict']]] = None,
            results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LiveToolsCableResultArgs', 'LiveToolsCableResultArgsDict']]]]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'LiveToolsCable':
        """
        Get an existing LiveToolsCable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cable_test_id: Id of the cable test request. Used to check the status of the request.
        :param pulumi.Input[Union['LiveToolsCableCallbackArgs', 'LiveToolsCableCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] error: An error message for a failed execution
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of ports for which to perform the cable test.
        :param pulumi.Input[Union['LiveToolsCableRequestArgs', 'LiveToolsCableRequestArgsDict']] request: Cable test request parameters
        :param pulumi.Input[Sequence[pulumi.Input[Union['LiveToolsCableResultArgs', 'LiveToolsCableResultArgsDict']]]] results: Results of the cable test request, one for each requested port.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[str] status: Status of the cable test request.
        :param pulumi.Input[str] url: GET this url to check the status of your cable test request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LiveToolsCableState.__new__(_LiveToolsCableState)

        __props__.__dict__["cable_test_id"] = cable_test_id
        __props__.__dict__["callback"] = callback
        __props__.__dict__["error"] = error
        __props__.__dict__["ports"] = ports
        __props__.__dict__["request"] = request
        __props__.__dict__["results"] = results
        __props__.__dict__["serial"] = serial
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        return LiveToolsCable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cableTestId")
    def cable_test_id(self) -> pulumi.Output[str]:
        """
        Id of the cable test request. Used to check the status of the request.
        """
        return pulumi.get(self, "cable_test_id")

    @property
    @pulumi.getter
    def callback(self) -> pulumi.Output['outputs.LiveToolsCableCallback']:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output[str]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of ports for which to perform the cable test.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def request(self) -> pulumi.Output['outputs.LiveToolsCableRequest']:
        """
        Cable test request parameters
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def results(self) -> pulumi.Output[Sequence['outputs.LiveToolsCableResult']]:
        """
        Results of the cable test request, one for each requested port.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the cable test request.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        GET this url to check the status of your cable test request.
        """
        return pulumi.get(self, "url")

