#ifndef FLS_COR_PRM_FACTOR_HPP
#define FLS_COR_PRM_FACTOR_HPP

#include "fls/cfg/cfg.hpp"
#include "fls/common/assert.hpp"
#include "fls/cor/fun.hpp"
#include "fls/utl/util.hpp"

namespace fastlanes { namespace factor {
/*---------------------------------------------------------------------------------------------------------------------\
 * Compress
\---------------------------------------------------------------------------------------------------------------------*/
void Compress64(Vec& src_vec, Vec& des_vec, CompressState& compress_state);

/*---------------------------------------------------------------------------------------------------------------------\
 * GetCompress
\---------------------------------------------------------------------------------------------------------------------*/
template <typename T>
cmpr_fun_t GetCompress() {
	if (std::is_same<T, uint64_t>()) {
		return Compress64;
	}
	if (std::is_same<T, int64_t>()) {
		return Compress64;
	}

	return nullptr;
}

/*---------------------------------------------------------------------------------------------------------------------\
 * Decompress
\---------------------------------------------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------------------------------------------\
 * GetDecompress
\---------------------------------------------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------------------------------------------\
 * Static Asserts
\---------------------------------------------------------------------------------------------------------------------*/
}}     // namespace fastlanes::factor
#endif // FLS_COR_PRM_FACTOR_HPP
