# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from Api42Vb.models.video import Video
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Playlist(BaseModel):
    """
    Playlist Object
    """ # noqa: E501
    id: StrictStr = Field(description="id of the playlist (null when adding a new video)")
    name: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="name of the playlist")
    description: Optional[Annotated[str, Field(strict=True, max_length=2048)]] = Field(default=None, description="description of the playlist")
    children: Optional[List[Video]] = Field(default=None, description="ordered list of video in the playlist")
    ctime: Optional[StrictInt] = Field(default=None, description="Creation date (timestamp)")
    mtime: Optional[StrictInt] = Field(default=None, description="Modification date (timestamp)")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "children", "ctime", "mtime"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Playlist from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item in self.children:
                if _item:
                    _items.append(_item.to_dict())
            _dict['children'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Playlist from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "children": [Video.from_dict(_item) for _item in obj.get("children")] if obj.get("children") is not None else None,
            "ctime": obj.get("ctime"),
            "mtime": obj.get("mtime")
        })
        return _obj


