# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr, field_validator
from pydantic import Field
from typing_extensions import Annotated
from Api42Vb.models.video_assets import VideoAssets
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Video(BaseModel):
    """
    Video Object
    """ # noqa: E501
    title: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="title of the video")
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="description of the video")
    public: Optional[StrictBool] = Field(default=None, description="Define if the video is public (it can be accessible by anybody with the video url). Default = tue")
    tags: Optional[List[StrictStr]] = Field(default=None, description="tags list linked to video")
    id: StrictStr = Field(description="id of the video (null when adding a new video)")
    status: Optional[StrictStr] = Field(default=None, description="Status of the video : * 'REQUESTED': video as been submited, waiting for its creation * 'CREATED': video has been created and file can be uploaded          * 'TRANSCODING': video is unvailable because still in the creation  & in encoding process * 'TRANSCODING_ERROR': video is unvailable because the encoding failed  * 'AVAILABLE': video is ready to be stream")
    duration: Optional[StrictInt] = Field(default=None, description="video duration in second")
    ctime: Optional[StrictInt] = Field(default=None, description="Creation date (timestamp)")
    mtime: Optional[StrictInt] = Field(default=None, description="Modification date (timestamp)")
    assets: Optional[VideoAssets] = None
    metas: Optional[Dict[str, Any]] = Field(default=None, description="metas data  free-form object: refere to the documentation")
    __properties: ClassVar[List[str]] = ["title", "description", "public", "tags", "id", "status", "duration", "ctime", "mtime", "assets", "metas"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('REQUESTED', 'CREATED', 'TRANSCODING', 'TRANSCODING_ERROR', 'AVAILABLE'):
            raise ValueError("must be one of enum values ('REQUESTED', 'CREATED', 'TRANSCODING', 'TRANSCODING_ERROR', 'AVAILABLE')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Video from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assets
        if self.assets:
            _dict['assets'] = self.assets.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Video from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "public": obj.get("public"),
            "tags": obj.get("tags"),
            "id": obj.get("id"),
            "status": obj.get("status"),
            "duration": obj.get("duration"),
            "ctime": obj.get("ctime"),
            "mtime": obj.get("mtime"),
            "assets": VideoAssets.from_dict(obj.get("assets")) if obj.get("assets") is not None else None,
            "metas": obj.get("metas")
        })
        return _obj


