# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.2
    Contact: code@42videobricks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr, field_validator
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VideoAttachment(BaseModel):
    """
    Video Attachment Object
    """ # noqa: E501
    video_id: StrictStr = Field(description="id of the video", alias="videoId")
    attachment_type: Optional[StrictStr] = Field(default='caption', description="Attachment type", alias="attachmentType")
    name: Optional[StrictStr] = Field(default=None, description="the name of file")
    url: Optional[StrictStr] = Field(default=None, description="the path of the content")
    locale: Optional[StrictStr] = Field(default=None, description="the local of attachment")
    __properties: ClassVar[List[str]] = ["videoId", "attachmentType", "name", "url", "locale"]

    @field_validator('attachment_type')
    def attachment_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('caption', 'subtitle'):
            raise ValueError("must be one of enum values ('caption', 'subtitle')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VideoAttachment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VideoAttachment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "videoId": obj.get("videoId"),
            "attachmentType": obj.get("attachmentType") if obj.get("attachmentType") is not None else 'caption',
            "name": obj.get("name"),
            "url": obj.get("url"),
            "locale": obj.get("locale")
        })
        return _obj


