from functools import reduce

large_primes = [1073750017, 1073741827, 1073742853, 1073741831, 1073741833, 1073743883, 1073744909, 1073741839, 1073742353, 
    1073741843, 1073743381, 1073745943, 1073742361, 1073743387, 1073743901, 1073744927, 1073741857, 1073755171, 1073743397, 
    1073749031, 1073742889, 1073743403, 1073746477, 1073748527, 1073743921, 1073746483, 1073756213, 1073742391, 1073743417, 
    1073753147, 1073743421, 1073744447, 1073742913, 1073741891, 1073751109, 1073756231, 1073758793, 1073749067, 1073744461, 
    1073745487, 1073744977, 1073742931, 1073741909, 1073752663, 1073742937, 1073748059, 1073746013, 1073747039, 1073743457, 
    1073743459, 1073743973, 1073757287, 1073749609, 1073744491, 1073743469, 1073742959, 1073745521, 1073741939, 1073747573, 
    1073743991, 1073745017, 1073755259, 1073756797, 1073742463, 1073741953, 1073751683, 1073750149, 1073742983, 1073748617, 
    1073748107, 1073743501, 1073763983, 1073741969, 1073741971, 1073744533, 1073751191, 1073743513, 1073750683, 1073742493, 
    1073743007, 1073749153, 1073741987, 1073745061, 1073748647, 1073741993, 1073745067, 1073744557, 1073750191, 1073746097, 
    1073747123, 1073742517, 1073743543, 1073744569, 1073744059, 1073743037, 1073745599, 1073747137, 1073746627, 1073744069, 
    1073744071, 1073743049, 1073743051, 1073746637, 1073746127, 1073744593, 1073746643, 1073742037, 1073745623, 1073743577, 
    1073744603, 1073753309, 1073747167, 1073745121, 1073751779, 1073742053, 1073743079, 1073750761, 1073754859, 1073744621, 
    1073746159, 1073745649, 1073743091, 1073743093, 1073742583, 1073742073, 1073766139, 1073742077, 1073752831, 1073748737, 
    1073749763, 1073746181, 1073757959, 1073744137, 1073742091, 1073752333, 1073748239, 1073743633, 1073743123, 1073747221, 
    1073746711, 1073743129, 1073750299, 1073752349, 1073742623, 1073742113, 1073747747, 1073743141, 1073747239, 1073744681, 
    1073744171, 1073752877, 1073744687, 1073752369, 1073749811, 1073746229, 1073743159, 1073745209, 1073743163, 1073742653, 
    1073747263, 1073748289, 1073746243, 1073744197, 1073746759, 1073745737, 1073742667, 1073748301, 1073742671, 1073742673, 
    1073757523, 1073743189, 1073747287, 1073742169, 1073752411, 1073755997, 1073743199, 1073746273, 1073745251, 1073749349, 
    1073743207, 1073745769, 1073745259, 1073745773, 1073746799, 1073753969, 1073742707, 1073745781, 1073748343, 1073742713, 
    1073742203, 1073751421, 1073747327, 1073742209, 1073749891, 1073744261, 1073744263, 1073752969, 1073742731, 1073743757, 
    1073742223, 1073746321, 1073753491, 1073745301, 1073772439, 1073742233, 1073750939, 1073745821, 1073753503, 1073746337, 
    1073744291, 1073751461, 1073745319, 1073744297, 1073746859, 1073744813, 1073742767, 1073750449, 1073742259, 1073742773, 
    1073744311, 1073746361, 1073743291, 1073744317, 1073749951, 1073747393, 1073745859, 1073742277, 1073743303, 1073748937, 
    1073746379, 1073754061, 1073745359, 1073742289, 1073744339, 1073745877, 1073743831, 1073753561, 1073742811, 1073746397, 
    1073743327, 1073745377, 1073743331, 1073749477, 1073749991, 1073743337, 1073745899, 1073755117, 1073749487, 1073747953, 
    1073746931, 1073743861, 1073746423, 1073744377, 1073746939, 1073748989, 1073743871]

def chinese_remainder(n, a):

    total = 0
    prod = reduce(lambda a, b: a*b, n)
 
    for n_i, a_i in zip(n, a):
        p = prod // n_i
        total += a_i * mul_inv(p, n_i) * p

    return total % prod
 
 
def mul_inv(a, b):

    b0 = b
    x0, x1 = 0, 1

    if (b == 1):
        return 1

    while (a > 1):
        q = a // b
        a, b = b, (a % b)
        x0, x1 = x1 - q * x0, x0

    if (x1 < 0):
        x1 += b0

    return x1 
