import yt.wrapper as yt
from yt.wrapper.cli_helpers import print_to_output


def _explain_id(**kwargs):
    print_to_output("Id: {}".format(kwargs["id"]))
    try:
        (a, b, c, d) = map(lambda x: int(x, 16), kwargs["id"].split('-'))
    except Exception:
        raise yt.YtError("Error: expect GUID like string, not \"{}\"".format(kwargs["id"]))
    print_to_output("  Epoch/Segment:  {} ({})".format(a, hex(a)))
    print_to_output("  Mutation:       {} ({})".format(b, hex(b)))
    print_to_output("  Cell tag:       {} ({})".format(c >> 16, hex(c >> 16)))
    print_to_output("  Object type:    {} ({}) - {}".format(c & 0xFFFF, hex(c & 0xFFFF), _OBJECT_TYPE.get(c & 0xFFFF, "unknown")))
    print_to_output("  Hash:           {} ({})".format(d, hex(d)))

    if not kwargs["local"]:
        print_to_output("On cluster \"{}\":".format(yt.config["proxy"]["url"]))
        if not yt.config["proxy"]["url"]:
            raise yt.YtError("Missed '--proxy' option, or add '--local' option")
        try:
            is_exists = yt.exists("#{}".format(kwargs["id"]))
            creation_range = yt.get("//sys/estimated_creation_time/{}".format(kwargs["id"]))
            print_to_output("  Exists:         {}".format(is_exists))
            print_to_output("  Creation range: {} - {}".format(creation_range["min"], creation_range["max"]))
        except yt.YtError as ex:
            print_to_output("  Got error")
            if ex.inner_errors:
                raise yt.YtError(ex.inner_errors[0]["message"])
            else:
                raise


def add_explain_id_parser(add_parser):
    parser = add_parser("explain-id", _explain_id)
    parser.add_argument("id", help="id (GUID like string)")
    parser.add_argument("--local", action="store_true", default=False, dest="local", help="Do not gather info from cluster")


_OBJECT_TYPE = {
    0: "null",
    1: "transaction",
    2: "atomic_tablet_transaction",
    3: "non_atomic_tablet_transaction",
    4: "nested_transaction",
    5: "externalized_transaction",
    6: "externalized_nested_transaction",
    7: "upload_transaction",
    8: "upload_nested_transaction",
    9: "system_transaction",
    10: "system_nested_transaction",
    407: "transaction_map",
    418: "topmost_transaction_map",
    422: "lock_map",
    100: "chunk",
    102: "erasure_chunk",
    103: "erasure_chunk_part_0",
    104: "erasure_chunk_part_1",
    105: "erasure_chunk_part_2",
    106: "erasure_chunk_part_3",
    107: "erasure_chunk_part_4",
    108: "erasure_chunk_part_5",
    109: "erasure_chunk_part_6",
    110: "erasure_chunk_part_7",
    111: "erasure_chunk_part_8",
    112: "erasure_chunk_part_9",
    113: "erasure_chunk_part_10",
    114: "erasure_chunk_part_11",
    115: "erasure_chunk_part_12",
    116: "erasure_chunk_part_13",
    117: "erasure_chunk_part_14",
    118: "erasure_chunk_part_15",
    119: "journal_chunk",
    121: "artifact",
    402: "chunk_map",
    403: "lost_chunk_map",
    413: "lost_vital_chunk_map",
    410: "precarious_chunk_map",
    411: "precarious_vital_chunk_map",
    404: "overreplicated_chunk_map",
    405: "underreplicated_chunk_map",
    419: "data_missing_chunk_map",
    420: "parity_missing_chunk_map",
    428: "oldest_part_missing_chunk_map",
    424: "quorum_missing_chunk_map",
    120: "unsafely_placed_chunk_map",
    160: "inconsistently_placed_chunk_map",
    434: "unexpected_overreplicated_chunk_map",
    436: "replica_temporarily_unavailable_chunk_map",
    122: "foreign_chunk_map",
    450: "local_lost_chunk_map",
    451: "local_lost_vital_chunk_map",
    452: "local_precarious_chunk_map",
    453: "local_precarious_vital_chunk_map",
    454: "local_overreplicated_chunk_map",
    455: "local_underreplicated_chunk_map",
    456: "local_data_missing_chunk_map",
    457: "local_parity_missing_chunk_map",
    458: "local_oldest_part_missing_chunk_map",
    459: "local_quorum_missing_chunk_map",
    460: "local_unsafely_placed_chunk_map",
    461: "local_inconsistently_placed_chunk_map",
    462: "local_unexpected_overreplicated_chunk_map",
    463: "local_replica_temporarily_unavailable_chunk_map",
    101: "chunk_list",
    406: "chunk_list_map",
    123: "chunk_view",
    430: "chunk_view_map",
    408: "domestic_medium",
    435: "s3medium",
    409: "medium_map",
    124: "erasure_journal_chunk",
    125: "erasure_journal_chunk_part_0",
    126: "erasure_journal_chunk_part_1",
    127: "erasure_journal_chunk_part_2",
    128: "erasure_journal_chunk_part_3",
    129: "erasure_journal_chunk_part_4",
    130: "erasure_journal_chunk_part_5",
    131: "erasure_journal_chunk_part_6",
    132: "erasure_journal_chunk_part_7",
    133: "erasure_journal_chunk_part_8",
    134: "erasure_journal_chunk_part_9",
    135: "erasure_journal_chunk_part_10",
    136: "erasure_journal_chunk_part_11",
    137: "erasure_journal_chunk_part_12",
    138: "erasure_journal_chunk_part_13",
    139: "erasure_journal_chunk_part_14",
    140: "erasure_journal_chunk_part_15",
    141: "chunk_location",
    142: "chunk_location_map",
    200: "lock",
    300: "string_node",
    301: "int64node",
    306: "uint64node",
    302: "double_node",
    303: "map_node",
    304: "list_node",
    305: "boolean_node",
    400: "file",
    401: "table",
    423: "journal",
    412: "orchid",
    417: "link",
    421: "document",
    425: "replicated_table",
    431: "replication_log_table",
    307: "access_control_object",
    432: "access_control_object_namespace",
    433: "access_control_object_namespace_map",
    1504: "sequoia_map_node",
    11004: "cypress_shard",
    11005: "cypress_shard_map",
    11000: "portal_entrance",
    11001: "portal_exit",
    11002: "portal_entrance_map",
    11003: "portal_exit_map",
    12000: "rootstock",
    12001: "scion",
    12002: "rootstock_map",
    12003: "scion_map",
    500: "account",
    414: "account_map",
    505: "account_resource_usage_lease",
    506: "account_resource_usage_lease_map",
    501: "user",
    415: "user_map",
    502: "group",
    416: "group_map",
    503: "network_project",
    426: "network_project_map",
    504: "proxy_role",
    427: "http_proxy_role_map",
    429: "rpc_proxy_role_map",
    1300: "master_table_schema",
    1301: "master_table_schema_map",
    1302: "table_collocation",
    1303: "secondary_index",
    600: "master",
    601: "master_cell",
    602: "sys_node",
    618: "alice_avenue_endpoint",
    619: "bob_avenue_endpoint",
    700: "tablet_cell",
    701: "tablet_cell_node",
    702: "tablet",
    703: "tablet_map",
    710: "tablet_cell_map",
    704: "sorted_dynamic_tablet_store",
    708: "ordered_dynamic_tablet_store",
    705: "tablet_partition",
    706: "tablet_cell_bundle",
    707: "tablet_cell_bundle_map",
    709: "table_replica",
    711: "tablet_action",
    712: "tablet_action_map",
    713: "area",
    714: "area_map",
    715: "hunk_storage",
    716: "hunk_tablet",
    800: "rack",
    801: "rack_map",
    802: "cluster_node",
    803: "cluster_node_node",
    804: "legacy_cluster_node_map",
    807: "cluster_node_map",
    808: "data_node_map",
    809: "exec_node_map",
    810: "tablet_node_map",
    811: "chaos_node_map",
    805: "data_center",
    806: "data_center_map",
    812: "host",
    813: "host_map",
    900: "scheduler_job",
    901: "master_job",
    1000: "operation",
    1001: "scheduler_pool",
    1002: "scheduler_pool_tree",
    1003: "scheduler_pool_tree_map",
    1100: "estimated_creation_time_map",
    1200: "chaos_cell",
    1201: "chaos_cell_bundle",
    1202: "chaos_cell_map",
    1203: "chaos_cell_bundle_map",
    1204: "replication_card",
    1205: "chaos_table_replica",
    1206: "chaos_replicated_table",
    1207: "replication_card_collocation",
    1500: "cluster_proxy_node",
    1400: "zookeeper_shard",
    1401: "zookeeper_shard_map",
}
