# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SensorMqttBrokersArgs', 'SensorMqttBrokers']

@pulumi.input_type
class SensorMqttBrokersArgs:
    def __init__(__self__, *,
                 mqtt_broker_id: pulumi.Input[builtins.str],
                 network_id: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a SensorMqttBrokers resource.
        :param pulumi.Input[builtins.str] mqtt_broker_id: ID of the MQTT Broker.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        """
        pulumi.set(__self__, "mqtt_broker_id", mqtt_broker_id)
        pulumi.set(__self__, "network_id", network_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the MQTT Broker.
        """
        return pulumi.get(self, "mqtt_broker_id")

    @mqtt_broker_id.setter
    def mqtt_broker_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mqtt_broker_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _SensorMqttBrokersState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SensorMqttBrokers resources.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        :param pulumi.Input[builtins.str] mqtt_broker_id: ID of the MQTT Broker.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mqtt_broker_id is not None:
            pulumi.set(__self__, "mqtt_broker_id", mqtt_broker_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the MQTT Broker.
        """
        return pulumi.get(self, "mqtt_broker_id")

    @mqtt_broker_id.setter
    def mqtt_broker_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mqtt_broker_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/sensorMqttBrokers:SensorMqttBrokers")
class SensorMqttBrokers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SensorMqttBrokers("example",
            enabled=True,
            mqtt_broker_id="string",
            network_id="string")
        pulumi.export("merakiNetworksSensorMqttBrokersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/sensorMqttBrokers:SensorMqttBrokers example "mqtt_broker_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        :param pulumi.Input[builtins.str] mqtt_broker_id: ID of the MQTT Broker.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensorMqttBrokersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SensorMqttBrokers("example",
            enabled=True,
            mqtt_broker_id="string",
            network_id="string")
        pulumi.export("merakiNetworksSensorMqttBrokersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/sensorMqttBrokers:SensorMqttBrokers example "mqtt_broker_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SensorMqttBrokersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensorMqttBrokersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensorMqttBrokersArgs.__new__(SensorMqttBrokersArgs)

            __props__.__dict__["enabled"] = enabled
            if mqtt_broker_id is None and not opts.urn:
                raise TypeError("Missing required property 'mqtt_broker_id'")
            __props__.__dict__["mqtt_broker_id"] = mqtt_broker_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(SensorMqttBrokers, __self__).__init__(
            'meraki:networks/sensorMqttBrokers:SensorMqttBrokers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            mqtt_broker_id: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SensorMqttBrokers':
        """
        Get an existing SensorMqttBrokers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        :param pulumi.Input[builtins.str] mqtt_broker_id: ID of the MQTT Broker.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensorMqttBrokersState.__new__(_SensorMqttBrokersState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["mqtt_broker_id"] = mqtt_broker_id
        __props__.__dict__["network_id"] = network_id
        return SensorMqttBrokers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the broker is enabled for sensor data. Currently, only a single broker may be enabled for sensor data.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the MQTT Broker.
        """
        return pulumi.get(self, "mqtt_broker_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

