# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InsightMonitoredMediaServersArgs', 'InsightMonitoredMediaServers']

@pulumi.input_type
class InsightMonitoredMediaServersArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[builtins.str],
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 best_effort_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_media_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InsightMonitoredMediaServers resource.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] address: The IP address (IPv4 only) or hostname of the media server to monitor
        :param pulumi.Input[builtins.bool] best_effort_monitoring_enabled: Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        :param pulumi.Input[builtins.str] monitored_media_server_id: monitoredMediaServerId path parameter. Monitored media server ID
        :param pulumi.Input[builtins.str] name: The name of the VoIP provider
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if best_effort_monitoring_enabled is not None:
            pulumi.set(__self__, "best_effort_monitoring_enabled", best_effort_monitoring_enabled)
        if monitored_media_server_id is not None:
            pulumi.set(__self__, "monitored_media_server_id", monitored_media_server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address (IPv4 only) or hostname of the media server to monitor
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="bestEffortMonitoringEnabled")
    def best_effort_monitoring_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        """
        return pulumi.get(self, "best_effort_monitoring_enabled")

    @best_effort_monitoring_enabled.setter
    def best_effort_monitoring_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "best_effort_monitoring_enabled", value)

    @property
    @pulumi.getter(name="monitoredMediaServerId")
    def monitored_media_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        monitoredMediaServerId path parameter. Monitored media server ID
        """
        return pulumi.get(self, "monitored_media_server_id")

    @monitored_media_server_id.setter
    def monitored_media_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitored_media_server_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VoIP provider
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _InsightMonitoredMediaServersState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 best_effort_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_media_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InsightMonitoredMediaServers resources.
        :param pulumi.Input[builtins.str] address: The IP address (IPv4 only) or hostname of the media server to monitor
        :param pulumi.Input[builtins.bool] best_effort_monitoring_enabled: Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        :param pulumi.Input[builtins.str] monitored_media_server_id: monitoredMediaServerId path parameter. Monitored media server ID
        :param pulumi.Input[builtins.str] name: The name of the VoIP provider
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if best_effort_monitoring_enabled is not None:
            pulumi.set(__self__, "best_effort_monitoring_enabled", best_effort_monitoring_enabled)
        if monitored_media_server_id is not None:
            pulumi.set(__self__, "monitored_media_server_id", monitored_media_server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address (IPv4 only) or hostname of the media server to monitor
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="bestEffortMonitoringEnabled")
    def best_effort_monitoring_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        """
        return pulumi.get(self, "best_effort_monitoring_enabled")

    @best_effort_monitoring_enabled.setter
    def best_effort_monitoring_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "best_effort_monitoring_enabled", value)

    @property
    @pulumi.getter(name="monitoredMediaServerId")
    def monitored_media_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        monitoredMediaServerId path parameter. Monitored media server ID
        """
        return pulumi.get(self, "monitored_media_server_id")

    @monitored_media_server_id.setter
    def monitored_media_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitored_media_server_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VoIP provider
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)


@pulumi.type_token("meraki:organizations/insightMonitoredMediaServers:InsightMonitoredMediaServers")
class InsightMonitoredMediaServers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 best_effort_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_media_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.InsightMonitoredMediaServers("example",
            address="123.123.123.1",
            best_effort_monitoring_enabled=True,
            name="Sample VoIP Provider",
            organization_id="string")
        pulumi.export("merakiOrganizationsInsightMonitoredMediaServersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/insightMonitoredMediaServers:InsightMonitoredMediaServers example "monitored_media_server_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The IP address (IPv4 only) or hostname of the media server to monitor
        :param pulumi.Input[builtins.bool] best_effort_monitoring_enabled: Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        :param pulumi.Input[builtins.str] monitored_media_server_id: monitoredMediaServerId path parameter. Monitored media server ID
        :param pulumi.Input[builtins.str] name: The name of the VoIP provider
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightMonitoredMediaServersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.InsightMonitoredMediaServers("example",
            address="123.123.123.1",
            best_effort_monitoring_enabled=True,
            name="Sample VoIP Provider",
            organization_id="string")
        pulumi.export("merakiOrganizationsInsightMonitoredMediaServersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/insightMonitoredMediaServers:InsightMonitoredMediaServers example "monitored_media_server_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param InsightMonitoredMediaServersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightMonitoredMediaServersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 best_effort_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_media_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightMonitoredMediaServersArgs.__new__(InsightMonitoredMediaServersArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["best_effort_monitoring_enabled"] = best_effort_monitoring_enabled
            __props__.__dict__["monitored_media_server_id"] = monitored_media_server_id
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
        super(InsightMonitoredMediaServers, __self__).__init__(
            'meraki:organizations/insightMonitoredMediaServers:InsightMonitoredMediaServers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[builtins.str]] = None,
            best_effort_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            monitored_media_server_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None) -> 'InsightMonitoredMediaServers':
        """
        Get an existing InsightMonitoredMediaServers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The IP address (IPv4 only) or hostname of the media server to monitor
        :param pulumi.Input[builtins.bool] best_effort_monitoring_enabled: Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        :param pulumi.Input[builtins.str] monitored_media_server_id: monitoredMediaServerId path parameter. Monitored media server ID
        :param pulumi.Input[builtins.str] name: The name of the VoIP provider
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InsightMonitoredMediaServersState.__new__(_InsightMonitoredMediaServersState)

        __props__.__dict__["address"] = address
        __props__.__dict__["best_effort_monitoring_enabled"] = best_effort_monitoring_enabled
        __props__.__dict__["monitored_media_server_id"] = monitored_media_server_id
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        return InsightMonitoredMediaServers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address (IPv4 only) or hostname of the media server to monitor
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="bestEffortMonitoringEnabled")
    def best_effort_monitoring_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates that if the media server doesn't respond to ICMP pings, the nearest hop will be used in its stead
        """
        return pulumi.get(self, "best_effort_monitoring_enabled")

    @property
    @pulumi.getter(name="monitoredMediaServerId")
    def monitored_media_server_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        monitoredMediaServerId path parameter. Monitored media server ID
        """
        return pulumi.get(self, "monitored_media_server_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the VoIP provider
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

