"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .annotations import Annotations, AnnotationsTypedDict
from .v2descriptor import V2Descriptor, V2DescriptorTypedDict
import pydantic
from speakeasy_client_sdk_python.types import BaseModel
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ManifestTypedDict(TypedDict):
    r"""Returns the requested manifest file"""

    annotations: NotRequired[AnnotationsTypedDict]
    r"""Annotations"""
    artifact_type: NotRequired[str]
    r"""Type of artifact"""
    layers: NotRequired[List[V2DescriptorTypedDict]]
    r"""List of V2 image layer information"""
    media_type: NotRequired[str]
    r"""Media type usually application/vnd.docker.distribution.manifest.v2+json if this is in the accept header"""
    schema_version: NotRequired[int]
    r"""Schema version"""


class Manifest(BaseModel):
    r"""Returns the requested manifest file"""

    annotations: Optional[Annotations] = None
    r"""Annotations"""

    artifact_type: Annotated[Optional[str], pydantic.Field(alias="artifactType")] = None
    r"""Type of artifact"""

    layers: Optional[List[V2Descriptor]] = None
    r"""List of V2 image layer information"""

    media_type: Annotated[Optional[str], pydantic.Field(alias="mediaType")] = None
    r"""Media type usually application/vnd.docker.distribution.manifest.v2+json if this is in the accept header"""

    schema_version: Annotated[Optional[int], pydantic.Field(alias="schemaVersion")] = (
        None
    )
    r"""Schema version"""
