"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from speakeasy_client_sdk_python.types import BaseModel
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WorkspaceTypedDict(TypedDict):
    r"""A speakeasy workspace"""

    created_at: datetime
    id: str
    name: str
    organization_id: str
    slug: str
    updated_at: datetime
    verified: bool
    inactive: NotRequired[bool]
    telemetry_disabled: NotRequired[bool]
    r"""Deprecated. Use organization.telemetry_disabled instead."""


class Workspace(BaseModel):
    r"""A speakeasy workspace"""

    created_at: datetime

    id: str

    name: str

    organization_id: str

    slug: str

    updated_at: datetime

    verified: bool

    inactive: Optional[bool] = None

    telemetry_disabled: Annotated[
        Optional[bool],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""Deprecated. Use organization.telemetry_disabled instead."""
