# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class ContentSource(UncheckedBaseModel):
    """
    The content source used by AI Agent in the conversation.
    """

    content_type: typing.Literal["custom_answer"] = pydantic.Field(default="custom_answer")
    """
    The type of the content source.
    """

    url: str = pydantic.Field()
    """
    The internal URL linking to the content source for teammates.
    """

    title: str = pydantic.Field()
    """
    The title of the content source.
    """

    locale: str = pydantic.Field()
    """
    The ISO 639 language code of the content source.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
