# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class HelpCenter(UncheckedBaseModel):
    """
    Help Centers contain collections
    """

    id: str = pydantic.Field()
    """
    The unique identifier for the Help Center which is given by Intercom.
    """

    workspace_id: str = pydantic.Field()
    """
    The id of the workspace which the Help Center belongs to.
    """

    created_at: int = pydantic.Field()
    """
    The time when the Help Center was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the Help Center was last updated.
    """

    identifier: str = pydantic.Field()
    """
    The identifier of the Help Center. This is used in the URL of the Help Center.
    """

    website_turned_on: bool = pydantic.Field()
    """
    Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
    """

    display_name: str = pydantic.Field()
    """
    The display name of the Help Center only seen by teammates.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
