# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .news_item_state import NewsItemState
from .newsfeed_assignment import NewsfeedAssignment


class NewsItem(UncheckedBaseModel):
    """
    A News Item is a content type in Intercom enabling you to announce product updates, company news, promotions, events and more with your customers.
    """

    type: typing.Literal["news-item"] = pydantic.Field(default="news-item")
    """
    The type of object.
    """

    id: str = pydantic.Field()
    """
    The unique identifier for the news item which is given by Intercom.
    """

    workspace_id: str = pydantic.Field()
    """
    The id of the workspace which the news item belongs to.
    """

    title: str = pydantic.Field()
    """
    The title of the news item.
    """

    body: str = pydantic.Field()
    """
    The news item body, which may contain HTML.
    """

    sender_id: int = pydantic.Field()
    """
    The id of the sender of the news item. Must be a teammate on the workspace.
    """

    state: NewsItemState = pydantic.Field()
    """
    News items will not be visible to your users in the assigned newsfeeds until they are set live.
    """

    newsfeed_assignments: typing.Optional[typing.List[NewsfeedAssignment]] = pydantic.Field(default=None)
    """
    A list of newsfeed_assignments to assign to the specified newsfeed.
    """

    labels: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Label names displayed to users to categorize the news item.
    """

    cover_image_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the image used as cover. Must have .jpg or .png extension.
    """

    reactions: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
    """

    deliver_silently: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.
    """

    created_at: int = pydantic.Field()
    """
    Timestamp for when the news item was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Timestamp for when the news item was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
