# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.translation import Translation
from .subscription_type_consent_type import SubscriptionTypeConsentType
from .subscription_type_content_types_item import SubscriptionTypeContentTypesItem
from .subscription_type_state import SubscriptionTypeState


class SubscriptionType(UncheckedBaseModel):
    """
    A subscription type lets customers easily opt out of non-essential communications without missing what's important to them.
    """

    type: typing.Literal["subscription"] = pydantic.Field(default="subscription")
    """
    The type of the object - subscription
    """

    id: str = pydantic.Field()
    """
    The unique identifier representing the subscription type.
    """

    state: SubscriptionTypeState = pydantic.Field()
    """
    The state of the subscription type.
    """

    default_translation: Translation
    translations: typing.List[Translation] = pydantic.Field()
    """
    An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.
    """

    consent_type: SubscriptionTypeConsentType = pydantic.Field()
    """
    Describes the type of consent.
    """

    content_types: typing.List[SubscriptionTypeContentTypesItem] = pydantic.Field()
    """
    The message types that this subscription supports - can contain `email` or `sms_message`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
