# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.reference import Reference


class Tag(UncheckedBaseModel):
    """
    A tag allows you to label your contacts, companies, and conversations and list them using that tag.
    """

    type: typing.Literal["tag"] = pydantic.Field(default="tag")
    """
    value is "tag"
    """

    id: str = pydantic.Field()
    """
    The id of the tag
    """

    name: str = pydantic.Field()
    """
    The name of the tag
    """

    applied_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the tag was applied to the object
    """

    applied_by: typing.Optional[Reference] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
