# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .admin_reply_conversation_request_message_type import AdminReplyConversationRequestMessageType
from .conversation_attachment_files import ConversationAttachmentFiles


class AdminReplyConversationRequest(UncheckedBaseModel):
    """
    Payload of the request to reply on behalf of an admin
    """

    message_type: AdminReplyConversationRequestMessageType
    type: typing.Literal["admin"] = "admin"
    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The text body of the reply. Notes accept some HTML formatting. Must be present for comment and note message types.
    """

    admin_id: str = pydantic.Field()
    """
    The id of the admin who is authoring the comment.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the reply was created. If not provided, the current time will be used.
    """

    attachment_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of image URLs that will be added as attachments. You can include up to 10 URLs.
    """

    attachment_files: typing.Optional[typing.List[ConversationAttachmentFiles]] = pydantic.Field(default=None)
    """
    A list of files that will be added as attachments. You can include up to 10 files
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
