# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ArticleStatistics(UncheckedBaseModel):
    """
    The statistics of an article.
    """

    type: typing.Literal["article_statistics"] = pydantic.Field(default="article_statistics")
    """
    The type of object - `article_statistics`.
    """

    views: int = pydantic.Field()
    """
    The number of total views the article has received.
    """

    conversions: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of conversations started from the article.
    """

    reactions: int = pydantic.Field()
    """
    The number of total reactions the article has received.
    """

    happy_reaction_percentage: float = pydantic.Field()
    """
    The percentage of happy reactions the article has received against other types of reaction.
    """

    neutral_reaction_percentage: float = pydantic.Field()
    """
    The percentage of neutral reactions the article has received against other types of reaction.
    """

    sad_reaction_percentage: float = pydantic.Field()
    """
    The percentage of sad reactions the article has received against other types of reaction.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
