# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..companies.types.company import Company
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .offset_pages import OffsetPages


class CompanyList(UncheckedBaseModel):
    """
    This will return a list of companies for the App.
    """

    pages: typing.Optional[OffsetPages] = None
    total_count: int = pydantic.Field()
    """
    The total number of companies.
    """

    data: typing.List[Company] = pydantic.Field()
    """
    An array containing Company Objects.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
