# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..admins.types.admin import Admin
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .context import Context


class ConfigureRequestZero(UncheckedBaseModel):
    workspace_id: str = pydantic.Field()
    """
    The workspace ID of the teammate. Attribute is app_id for V1.2 and below.
    """

    admin: Admin = pydantic.Field()
    """
    The Intercom teammate configuring the app.
    """

    context: Context = pydantic.Field()
    """
    The context of where the app is added, where the user last visited, and information on the Messenger settings.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
