# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..contacts.types.contact import Contact
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .cursor_pages import CursorPages


class ContactList(UncheckedBaseModel):
    """
    Contacts are your users in Intercom.
    """

    type: typing.Literal["list"] = pydantic.Field(default="list")
    """
    Always list
    """

    data: typing.List[Contact] = pydantic.Field()
    """
    The list of contact objects
    """

    total_count: int = pydantic.Field()
    """
    A count of the total number of objects.
    """

    pages: typing.Optional[CursorPages] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
