# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .contact_reference import ContactReference
from .reference import Reference


class ConversationRating(UncheckedBaseModel):
    """
    The Conversation Rating object which contains information on the rating and/or remark added by a Contact and the Admin assigned to the conversation.
    """

    rating: int = pydantic.Field()
    """
    The rating, between 1 and 5, for the conversation.
    """

    remark: str = pydantic.Field()
    """
    An optional field to add a remark to correspond to the number rating
    """

    created_at: int = pydantic.Field()
    """
    The time the rating was requested in the conversation being rated.
    """

    contact: ContactReference
    teammate: Reference

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
