# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .image_component_align import ImageComponentAlign
from .url_action_component import UrlActionComponent


class ImageComponent(UncheckedBaseModel):
    """
    An image component is used to display an image.

    HTTPS Images:
    If your request URLs (or website URLs) are over HTTPS, you will need to ensure that images are loaded over HTTPS likewise. Otherwise, they will not work.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the component.
    """

    url: str = pydantic.Field()
    """
    The URL where the image is located.
    """

    align: typing.Optional[ImageComponentAlign] = pydantic.Field(default=None)
    """
    Aligns the image inside the component. Default is `left`.
    """

    width: int = pydantic.Field()
    """
    The exact width of the image in pixels.
    """

    height: int = pydantic.Field()
    """
    The exact height of the image in pixels.
    """

    rounded: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Rounds the corners of the image. Default is `false`.
    """

    bottom_margin: typing.Optional[typing.Literal["none"]] = pydantic.Field(default=None)
    """
    Disables a component's margin-bottom of 10px.
    """

    action: typing.Optional[UrlActionComponent] = pydantic.Field(default=None)
    """
    This can be a URL Action only.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
