# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .canvas_object import CanvasObject
from .event import Event


class SubmitResponse(UncheckedBaseModel):
    """
    The response object returned when submitting an app interaction. This will replace the previous canvas that was visible until the app was interacted with.

    You can optionally provide an event object with the attribute `type` given as `completed` to tell us if the app has completed its purpose. For example, an email collector app would be complete when the end-user submits their email address.

    Apps in conversation details can also optionally insert an app into the conversation reply:

    1. You respond with a card_creation_options object (https://developers.intercom.com/canvas-kit-reference/reference/card-creation-options)
    2. We send a request to the initialize URL for Messenger capabilities (https://developers.intercom.com/docs/build-an-integration/getting-started/build-an-app-for-your-messenger/request-flows) with the card_creation_options object present
    3. You respond with a canvas object with the components you want to insert into the conversation reply
    """

    canvas: CanvasObject = pydantic.Field()
    """
    The canvas object that defines the new UI to be shown.
    """

    card_creation_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Optional. Key-value pairs that will be sent in the initialize request to insert an app into the conversation reply.
    """

    event: typing.Optional[Event] = pydantic.Field(default=None)
    """
    Optional. Indicates if the app has completed its purpose.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
