# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .text_component_align import TextComponentAlign
from .text_component_style import TextComponentStyle


class TextComponent(UncheckedBaseModel):
    """
    A text component is used for rendering blocks of text. Links and bold font can be rendered through Markdown. There are different styles provided which edit the color, weight, and font size. These cannot be edited through Markdown.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the component.
    """

    text: str = pydantic.Field()
    """
    The text that will be rendered.
    """

    align: typing.Optional[TextComponentAlign] = pydantic.Field(default=None)
    """
    Aligns the text. Default is `left`.
    """

    style: typing.Optional[TextComponentStyle] = pydantic.Field(default=None)
    """
    Styles the text. Default is `paragraph`.
    """

    bottom_margin: typing.Optional[typing.Literal["none"]] = pydantic.Field(default=None)
    """
    Disables a component's margin-bottom of 10px.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
