# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.away_status_reason import AwayStatusReason
from .raw_client import AsyncRawAwayStatusReasonsClient, RawAwayStatusReasonsClient


class AwayStatusReasonsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAwayStatusReasonsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAwayStatusReasonsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAwayStatusReasonsClient
        """
        return self._raw_client

    def list_away_status_reasons(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AwayStatusReason]:
        """
        Returns a list of all away status reasons configured for the workspace, including deleted ones.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AwayStatusReason]
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.away_status_reasons.list_away_status_reasons()
        """
        _response = self._raw_client.list_away_status_reasons(request_options=request_options)
        return _response.data


class AsyncAwayStatusReasonsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAwayStatusReasonsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAwayStatusReasonsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAwayStatusReasonsClient
        """
        return self._raw_client

    async def list_away_status_reasons(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AwayStatusReason]:
        """
        Returns a list of all away status reasons configured for the workspace, including deleted ones.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AwayStatusReason]
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.away_status_reasons.list_away_status_reasons()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_away_status_reasons(request_options=request_options)
        return _response.data
