# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from ...types.contact_companies import ContactCompanies
from ...types.contact_location import ContactLocation
from ...types.contact_notes import ContactNotes
from ...types.contact_social_profiles import ContactSocialProfiles
from ...types.contact_tags import ContactTags
from .contact_avatar import ContactAvatar


class Contact(UncheckedBaseModel):
    """
    Contacts represent your leads and users in Intercom.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of object.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the contact which is given by Intercom.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the contact which is provided by the Client.
    """

    workspace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the workspace which the contact belongs to.
    """

    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    The role of the contact.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's email.
    """

    email_domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's email domain.
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contacts phone.
    """

    formatted_phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contacts phone number normalized to the E164 format
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contacts name.
    """

    owner_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of an admin that has been assigned account ownership of the contact.
    """

    has_hard_bounced: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact has had an email sent to them hard bounce.
    """

    marked_email_as_spam: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact has marked an email sent to them as spam.
    """

    unsubscribed_from_emails: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact is unsubscribed from emails.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact was last updated.
    """

    signed_up_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time specified for when a contact signed up.
    """

    last_seen_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).
    """

    last_replied_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact last messaged in.
    """

    last_contacted_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact was last messaged.
    """

    last_email_opened_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact last opened an email.
    """

    last_email_clicked_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact last clicked a link in an email.
    """

    language_override: typing.Optional[str] = pydantic.Field(default=None)
    """
    A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.
    """

    browser: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the browser which the contact is using.
    """

    browser_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the browser which the contact is using.
    """

    browser_language: typing.Optional[str] = pydantic.Field(default=None)
    """
    The language set by the browser which the contact is using.
    """

    os: typing.Optional[str] = pydantic.Field(default=None)
    """
    The operating system which the contact is using.
    """

    android_app_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the Android app which the contact is using.
    """

    android_app_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the Android app which the contact is using.
    """

    android_device: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Android device which the contact is using.
    """

    android_os_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the Android OS which the contact is using.
    """

    android_sdk_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the Android SDK which the contact is using.
    """

    android_last_seen_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The time when the contact was last seen on an Android device.
    """

    ios_app_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the iOS app which the contact is using.
    """

    ios_app_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the iOS app which the contact is using.
    """

    ios_device: typing.Optional[str] = pydantic.Field(default=None)
    """
    The iOS device which the contact is using.
    """

    ios_os_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of iOS which the contact is using.
    """

    ios_sdk_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the iOS SDK which the contact is using.
    """

    ios_last_seen_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    (UNIX timestamp) The last time the contact used the iOS app.
    """

    custom_attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The custom attributes which are set for the contact.
    """

    avatar: typing.Optional[ContactAvatar] = None
    tags: typing.Optional[ContactTags] = None
    notes: typing.Optional[ContactNotes] = None
    companies: typing.Optional[ContactCompanies] = None
    location: typing.Optional[ContactLocation] = None
    social_profiles: typing.Optional[ContactSocialProfiles] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
