# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.deleted_object import DeletedObject
from ..types.news_item_request_state import NewsItemRequestState
from ..types.paginated_response import PaginatedResponse
from .raw_client import AsyncRawNewsClient, RawNewsClient
from .types.news_item import NewsItem
from .types.newsfeed import Newsfeed
from .types.newsfeed_assignment import NewsfeedAssignment

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NewsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNewsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNewsClient
        """
        return self._raw_client

    def list_news_items(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all news items

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.list_news_items()
        """
        _response = self._raw_client.list_news_items(request_options=request_options)
        return _response.data

    def create_news_item(
        self,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NewsItem:
        """
        You can create a news item

        Parameters
        ----------
        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable.news import NewsfeedAssignment

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.create_news_item(
            title="Halloween is here!",
            body="<p>New costumes in store for this spooky season</p>",
            sender_id=991267834,
            state="live",
            deliver_silently=True,
            labels=["Product", "Update", "New"],
            reactions=["😆", "😅"],
            newsfeed_assignments=[
                NewsfeedAssignment(
                    newsfeed_id=53,
                    published_at=1664638214,
                )
            ],
        )
        """
        _response = self._raw_client.create_news_item(
            title=title,
            sender_id=sender_id,
            body=body,
            state=state,
            deliver_silently=deliver_silently,
            labels=labels,
            reactions=reactions,
            newsfeed_assignments=newsfeed_assignments,
            request_options=request_options,
        )
        return _response.data

    def retrieve_news_item(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> NewsItem:
        """
        You can fetch the details of a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.retrieve_news_item(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_news_item(id, request_options=request_options)
        return _response.data

    def update_news_item(
        self,
        id: int,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NewsItem:
        """
        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.update_news_item(
            id=1,
            title="Christmas is here!",
            body="<p>New gifts in store for the jolly season</p>",
            sender_id=991267845,
            reactions=["😝", "😂"],
        )
        """
        _response = self._raw_client.update_news_item(
            id,
            title=title,
            sender_id=sender_id,
            body=body,
            state=state,
            deliver_silently=deliver_silently,
            labels=labels,
            reactions=reactions,
            newsfeed_assignments=newsfeed_assignments,
            request_options=request_options,
        )
        return _response.data

    def delete_news_item(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> DeletedObject:
        """
        You can delete a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.delete_news_item(
            id=1,
        )
        """
        _response = self._raw_client.delete_news_item(id, request_options=request_options)
        return _response.data

    def list_live_newsfeed_items(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaginatedResponse:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.list_live_newsfeed_items(
            id="123",
        )
        """
        _response = self._raw_client.list_live_newsfeed_items(id, request_options=request_options)
        return _response.data

    def list_newsfeeds(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.list_newsfeeds()
        """
        _response = self._raw_client.list_newsfeeds(request_options=request_options)
        return _response.data

    def retrieve_newsfeed(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Newsfeed:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Newsfeed
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.news.retrieve_newsfeed(
            id="123",
        )
        """
        _response = self._raw_client.retrieve_newsfeed(id, request_options=request_options)
        return _response.data


class AsyncNewsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNewsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNewsClient
        """
        return self._raw_client

    async def list_news_items(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all news items

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.list_news_items()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_news_items(request_options=request_options)
        return _response.data

    async def create_news_item(
        self,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NewsItem:
        """
        You can create a news item

        Parameters
        ----------
        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable.news import NewsfeedAssignment

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.create_news_item(
                title="Halloween is here!",
                body="<p>New costumes in store for this spooky season</p>",
                sender_id=991267834,
                state="live",
                deliver_silently=True,
                labels=["Product", "Update", "New"],
                reactions=["😆", "😅"],
                newsfeed_assignments=[
                    NewsfeedAssignment(
                        newsfeed_id=53,
                        published_at=1664638214,
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_news_item(
            title=title,
            sender_id=sender_id,
            body=body,
            state=state,
            deliver_silently=deliver_silently,
            labels=labels,
            reactions=reactions,
            newsfeed_assignments=newsfeed_assignments,
            request_options=request_options,
        )
        return _response.data

    async def retrieve_news_item(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> NewsItem:
        """
        You can fetch the details of a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.retrieve_news_item(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_news_item(id, request_options=request_options)
        return _response.data

    async def update_news_item(
        self,
        id: int,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NewsItem:
        """
        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NewsItem
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.update_news_item(
                id=1,
                title="Christmas is here!",
                body="<p>New gifts in store for the jolly season</p>",
                sender_id=991267845,
                reactions=["😝", "😂"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_news_item(
            id,
            title=title,
            sender_id=sender_id,
            body=body,
            state=state,
            deliver_silently=deliver_silently,
            labels=labels,
            reactions=reactions,
            newsfeed_assignments=newsfeed_assignments,
            request_options=request_options,
        )
        return _response.data

    async def delete_news_item(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedObject:
        """
        You can delete a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.delete_news_item(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_news_item(id, request_options=request_options)
        return _response.data

    async def list_live_newsfeed_items(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaginatedResponse:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.list_live_newsfeed_items(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_live_newsfeed_items(id, request_options=request_options)
        return _response.data

    async def list_newsfeeds(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.list_newsfeeds()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_newsfeeds(request_options=request_options)
        return _response.data

    async def retrieve_newsfeed(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Newsfeed:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Newsfeed
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.news.retrieve_newsfeed(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_newsfeed(id, request_options=request_options)
        return _response.data
