# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.deleted_object import DeletedObject
from ..types.error import Error
from ..types.news_item_request_state import NewsItemRequestState
from ..types.paginated_response import PaginatedResponse
from .types.news_item import NewsItem
from .types.newsfeed import Newsfeed
from .types.newsfeed_assignment import NewsfeedAssignment

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawNewsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_news_items(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all news items

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedResponse]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "news/news_items",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_news_item(
        self,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NewsItem]:
        """
        You can create a news item

        Parameters
        ----------
        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NewsItem]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "news/news_items",
            method="POST",
            json={
                "title": title,
                "body": body,
                "sender_id": sender_id,
                "state": state,
                "deliver_silently": deliver_silently,
                "labels": labels,
                "reactions": reactions,
                "newsfeed_assignments": convert_and_respect_annotation_metadata(
                    object_=newsfeed_assignments, annotation=typing.Sequence[NewsfeedAssignment], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_news_item(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[NewsItem]:
        """
        You can fetch the details of a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NewsItem]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_news_item(
        self,
        id: int,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NewsItem]:
        """
        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NewsItem]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "body": body,
                "sender_id": sender_id,
                "state": state,
                "deliver_silently": deliver_silently,
                "labels": labels,
                "reactions": reactions,
                "newsfeed_assignments": convert_and_respect_annotation_metadata(
                    object_=newsfeed_assignments, annotation=typing.Sequence[NewsfeedAssignment], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_news_item(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeletedObject]:
        """
        You can delete a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeletedObject]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedObject,
                    construct_type(
                        type_=DeletedObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_live_newsfeed_items(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedResponse]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"news/newsfeeds/{jsonable_encoder(id)}/items",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_newsfeeds(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedResponse]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "news/newsfeeds",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_newsfeed(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Newsfeed]:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Newsfeed]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"news/newsfeeds/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Newsfeed,
                    construct_type(
                        type_=Newsfeed,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawNewsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_news_items(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all news items

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedResponse]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "news/news_items",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_news_item(
        self,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NewsItem]:
        """
        You can create a news item

        Parameters
        ----------
        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NewsItem]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "news/news_items",
            method="POST",
            json={
                "title": title,
                "body": body,
                "sender_id": sender_id,
                "state": state,
                "deliver_silently": deliver_silently,
                "labels": labels,
                "reactions": reactions,
                "newsfeed_assignments": convert_and_respect_annotation_metadata(
                    object_=newsfeed_assignments, annotation=typing.Sequence[NewsfeedAssignment], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_news_item(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[NewsItem]:
        """
        You can fetch the details of a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NewsItem]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_news_item(
        self,
        id: int,
        *,
        title: str,
        sender_id: int,
        body: typing.Optional[str] = OMIT,
        state: typing.Optional[NewsItemRequestState] = OMIT,
        deliver_silently: typing.Optional[bool] = OMIT,
        labels: typing.Optional[typing.Sequence[str]] = OMIT,
        reactions: typing.Optional[typing.Sequence[typing.Optional[str]]] = OMIT,
        newsfeed_assignments: typing.Optional[typing.Sequence[NewsfeedAssignment]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NewsItem]:
        """
        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        title : str
            The title of the news item.

        sender_id : int
            The id of the sender of the news item. Must be a teammate on the workspace.

        body : typing.Optional[str]
            The news item body, which may contain HTML.

        state : typing.Optional[NewsItemRequestState]
            News items will not be visible to your users in the assigned newsfeeds until they are set live.

        deliver_silently : typing.Optional[bool]
            When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.

        labels : typing.Optional[typing.Sequence[str]]
            Label names displayed to users to categorize the news item.

        reactions : typing.Optional[typing.Sequence[typing.Optional[str]]]
            Ordered list of emoji reactions to the news item. When empty, reactions are disabled.

        newsfeed_assignments : typing.Optional[typing.Sequence[NewsfeedAssignment]]
            A list of newsfeed_assignments to assign to the specified newsfeed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NewsItem]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "body": body,
                "sender_id": sender_id,
                "state": state,
                "deliver_silently": deliver_silently,
                "labels": labels,
                "reactions": reactions,
                "newsfeed_assignments": convert_and_respect_annotation_metadata(
                    object_=newsfeed_assignments, annotation=typing.Sequence[NewsfeedAssignment], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    NewsItem,
                    construct_type(
                        type_=NewsItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_news_item(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeletedObject]:
        """
        You can delete a single news item.

        Parameters
        ----------
        id : int
            The unique identifier for the news item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeletedObject]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"news/news_items/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedObject,
                    construct_type(
                        type_=DeletedObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_live_newsfeed_items(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedResponse]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"news/newsfeeds/{jsonable_encoder(id)}/items",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_newsfeeds(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PaginatedResponse]:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedResponse]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "news/newsfeeds",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedResponse,
                    construct_type(
                        type_=PaginatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_newsfeed(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Newsfeed]:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Newsfeed]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"news/newsfeeds/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Newsfeed,
                    construct_type(
                        type_=Newsfeed,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
