# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.ticket_state_list import TicketStateList
from .raw_client import AsyncRawTicketStatesClient, RawTicketStatesClient


class TicketStatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketStatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketStatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketStatesClient
        """
        return self._raw_client

    def list_ticket_states(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketStateList:
        """
        You can get a list of all ticket states for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketStateList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.ticket_states.list_ticket_states()
        """
        _response = self._raw_client.list_ticket_states(request_options=request_options)
        return _response.data


class AsyncTicketStatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketStatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketStatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketStatesClient
        """
        return self._raw_client

    async def list_ticket_states(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketStateList:
        """
        You can get a list of all ticket states for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketStateList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.ticket_states.list_ticket_states()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_ticket_states(request_options=request_options)
        return _response.data
