# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class App(UncheckedBaseModel):
    """
    App is a workspace on Intercom
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    """

    id_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the app.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the app.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom region the app is located in.
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The timezone of the region where the app is located.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    When the app was created.
    """

    identity_verification: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the app uses identity verification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
